% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AcqFunctionSmsEgo.R
\name{mlr_acqfunctions_smsego}
\alias{mlr_acqfunctions_smsego}
\alias{AcqFunctionSmsEgo}
\title{Acquisition Function SMS-EGO}
\description{
S-Metric Selection Evolutionary Multi-Objective Optimization Algorithm Acquisition Function.
}
\section{Parameters}{

\itemize{
\item \code{"lambda"} (\code{numeric(1)})\cr
\eqn{\lambda} value used for the confidence bound.
Defaults to \code{1}.
Based on \code{confidence = (1 - 2 * dnorm(lambda)) ^ m} you can calculate a
lambda for a given confidence level, see Ponweiser et al. (2008).
\item \code{"epsilon"} (\code{numeric(1)})\cr
\eqn{\epsilon} used for the additive epsilon dominance.
Can either be a single numeric value > 0 or \code{NULL} (default).
In the case of being \code{NULL}, an epsilon vector is maintained dynamically as
described in Horn et al. (2015).
}
}

\examples{
if (requireNamespace("mlr3learners") &
    requireNamespace("DiceKriging") &
    requireNamespace("rgenoud")) {
  library(bbotk)
  library(paradox)
  library(mlr3learners)
  library(data.table)

  fun = function(xs) {
    list(y1 = xs$x^2, y2 = (xs$x - 2) ^ 2)
  }
  domain = ps(x = p_dbl(lower = -10, upper = 10))
  codomain = ps(y1 = p_dbl(tags = "minimize"), y2 = p_dbl(tags = "minimize"))
  objective = ObjectiveRFun$new(fun = fun, domain = domain, codomain = codomain)

  instance = OptimInstanceBatchMultiCrit$new(
    objective = objective,
    terminator = trm("evals", n_evals = 5))

  instance$eval_batch(data.table(x = c(-6, -5, 3, 9)))

  learner = default_gp()

  surrogate = srlrn(list(learner, learner$clone(deep = TRUE)), archive = instance$archive)

  acq_function = acqf("smsego", surrogate = surrogate)

  acq_function$surrogate$update()
  acq_function$progress = 5 - 4 # n_evals = 5 and 4 points already evaluated
  acq_function$update()
  acq_function$eval_dt(data.table(x = c(-1, 0, 1)))
}
}
\references{
\itemize{
\item Ponweiser, Wolfgang, Wagner, Tobias, Biermann, Dirk, Vincze, Markus (2008).
\dQuote{Multiobjective Optimization on a Limited Budget of Evaluations Using Model-Assisted S-Metric Selection.}
In \emph{Proceedings of the 10th International Conference on Parallel Problem Solving from Nature}, 784--794.
\item Horn, Daniel, Wagner, Tobias, Biermann, Dirk, Weihs, Claus, Bischl, Bernd (2015).
\dQuote{Model-Based Multi-objective Optimization: Taxonomy, Multi-Point Proposal, Toolbox and Benchmark.}
In \emph{International Conference on Evolutionary Multi-Criterion Optimization}, 64--78.
}
}
\seealso{
Other Acquisition Function: 
\code{\link{AcqFunction}},
\code{\link{mlr_acqfunctions}},
\code{\link{mlr_acqfunctions_aei}},
\code{\link{mlr_acqfunctions_cb}},
\code{\link{mlr_acqfunctions_ehvi}},
\code{\link{mlr_acqfunctions_ehvigh}},
\code{\link{mlr_acqfunctions_ei}},
\code{\link{mlr_acqfunctions_eips}},
\code{\link{mlr_acqfunctions_mean}},
\code{\link{mlr_acqfunctions_multi}},
\code{\link{mlr_acqfunctions_pi}},
\code{\link{mlr_acqfunctions_sd}}
}
\concept{Acquisition Function}
\section{Super classes}{
\code{\link[bbotk:Objective]{bbotk::Objective}} -> \code{\link[mlr3mbo:AcqFunction]{mlr3mbo::AcqFunction}} -> \code{AcqFunctionSmsEgo}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{ys_front}}{(\code{matrix()})\cr
Approximated Pareto front.
Signs are corrected with respect to assuming minimization of objectives.}

\item{\code{ref_point}}{(\code{numeric()})\cr
Reference point.
Signs are corrected with respect to assuming minimization of objectives.}

\item{\code{epsilon}}{(\code{numeric()})\cr
Epsilon used for the additive epsilon dominance.}

\item{\code{progress}}{(\code{numeric(1)})\cr
Optimization progress (typically, the number of function evaluations left).
Note that this requires the \link[bbotk:OptimInstance]{bbotk::OptimInstance} to be terminated via a \link[bbotk:mlr_terminators_evals]{bbotk::TerminatorEvals}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AcqFunctionSmsEgo-new}{\code{AcqFunctionSmsEgo$new()}}
\item \href{#method-AcqFunctionSmsEgo-update}{\code{AcqFunctionSmsEgo$update()}}
\item \href{#method-AcqFunctionSmsEgo-clone}{\code{AcqFunctionSmsEgo$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="eval"><a href='../../bbotk/html/Objective.html#method-Objective-eval'><code>bbotk::Objective$eval()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="format"><a href='../../bbotk/html/Objective.html#method-Objective-format'><code>bbotk::Objective$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="help"><a href='../../bbotk/html/Objective.html#method-Objective-help'><code>bbotk::Objective$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="print"><a href='../../bbotk/html/Objective.html#method-Objective-print'><code>bbotk::Objective$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="AcqFunction" data-id="eval_dt"><a href='../../mlr3mbo/html/AcqFunction.html#method-AcqFunction-eval_dt'><code>mlr3mbo::AcqFunction$eval_dt()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="AcqFunction" data-id="eval_many"><a href='../../mlr3mbo/html/AcqFunction.html#method-AcqFunction-eval_many'><code>mlr3mbo::AcqFunction$eval_many()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqFunctionSmsEgo-new"></a>}}
\if{latex}{\out{\hypertarget{method-AcqFunctionSmsEgo-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqFunctionSmsEgo$new(surrogate = NULL, lambda = 1, epsilon = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{surrogate}}{(\code{NULL} | \link{SurrogateLearnerCollection}).}

\item{\code{lambda}}{(\code{numeric(1)}).}

\item{\code{epsilon}}{(\code{NULL} | \code{numeric(1)}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqFunctionSmsEgo-update"></a>}}
\if{latex}{\out{\hypertarget{method-AcqFunctionSmsEgo-update}{}}}
\subsection{Method \code{update()}}{
Update the acquisition function and set \code{ys_front}, \code{ref_point} and \code{epsilon}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqFunctionSmsEgo$update()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqFunctionSmsEgo-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AcqFunctionSmsEgo-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqFunctionSmsEgo$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
