% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataBackendDataTable.R, R/DataBackendMatrix.R,
%   R/as_data_backend.R
\name{as_data_backend.data.frame}
\alias{as_data_backend.data.frame}
\alias{as_data_backend.Matrix}
\alias{as_data_backend}
\title{Create a Data Backend}
\usage{
\method{as_data_backend}{data.frame}(data, primary_key = NULL, keep_rownames = FALSE, ...)

\method{as_data_backend}{Matrix}(data, primary_key = NULL, dense = NULL, ...)

as_data_backend(data, primary_key = NULL, ...)
}
\arguments{
\item{data}{\code{any}\cr
Data to create a \link{DataBackend} from.
For a \code{data.frame()} (this includes \code{tibble()} from \CRANpkg{tibble} and \code{\link[data.table:data.table]{data.table::data.table()}}),
a \link{DataBackendDataTable} is created.
See \code{methods("as_data_backend")} for possible input formats.

Package \CRANpkg{mlr3db} extends this function with a method for lazy table objects implemented in \CRANpkg{dbplyr}.
This allows to interface many different data base systems such as SQL servers.}

\item{primary_key}{(\code{character(1)} | \code{integer()})\cr
Name of the primary key column, or integer vector of row ids.}

\item{keep_rownames}{(\code{logical(1)} | \code{character(1)})\cr
If \code{TRUE} or a single string, keeps the row names of \code{data} as a new column.
The column is named like the provided string, defaulting to \code{"..rownames"} for \code{keep_rownames == TRUE}.
Note that the created column will be used as a regular feature by the task unless you manually change the column role.
Also see \code{\link[data.table:as.data.table]{data.table::as.data.table()}}.}

\item{...}{(\code{any})\cr
Additional arguments passed to the respective \link{DataBackend} method.}

\item{dense}{(\code{\link[=data.frame]{data.frame()}}).
Dense data.}
}
\value{
\link{DataBackend}.
}
\description{
Wraps a \link{DataBackend} around data.
}
\examples{
# create a new backend using the iris data:
as_data_backend(iris)
}
\seealso{
Other DataBackend: 
\code{\link{DataBackendDataTable}},
\code{\link{DataBackendMatrix}},
\code{\link{DataBackend}}
}
\concept{DataBackend}
