% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Task.R
\name{Task}
\alias{Task}
\title{Task Class}
\description{
This is the abstract base class for \link{TaskSupervised} and \link{TaskUnsupervised}.
\link{TaskClassif} and \link{TaskRegr} inherit from \link{TaskSupervised}.
More supervised tasks are implemented in \CRANpkg{mlr3proba}, unsupervised cluster tasks
in package \CRANpkg{mlr3cluster}.

Tasks serve two purposes:
\enumerate{
\item Tasks wrap a \link{DataBackend}, an object to transparently interface different data storage types.
\item Tasks store meta-information, such as the role of the individual columns in the \link{DataBackend}.
For example, for a classification task a single column must be marked as target column, and others as features.
}

Predefined (toy) tasks are stored in the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_tasks},
e.g. \code{\link[=mlr_tasks_penguins]{penguins}} or \code{\link[=mlr_tasks_boston_housing]{boston_housing}}.
More toy tasks can be found in the dictionary after loading \CRANpkg{mlr3data}.
}
\section{S3 methods}{

\itemize{
\item \code{as.data.table(t)}\cr
\link{Task} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns the complete data as \code{\link[data.table:data.table]{data.table::data.table()}}.
}
}

\section{Task mutators}{

The following methods change the task in-place:
\itemize{
\item Any modification of the lists \verb{$col_roles} or \verb{$row_roles}.
This provides a different "view" on the data without altering the data itself.
\item Modification of column or row roles via \verb{$set_col_roles()} or \verb{$set_row_roles()}, respectively.
\item \verb{$filter()} and \verb{$select()} subset the set of active rows or features in \verb{$row_roles} or \verb{$col_roles}, respectively.
This provides a different "view" on the data without altering the data itself.
\item \code{rbind()} and \code{cbind()} change the task in-place by binding rows or columns to the data, but without modifying the original \link{DataBackend}.
Instead, the methods first create a new \link{DataBackendDataTable} from the provided new data, and then
merge both backends into an abstract \link{DataBackend} which merges the results on-demand.
\item \code{rename()} wraps the \link{DataBackend} of the Task in an additional \link{DataBackend} which deals with the renaming. Also updates \verb{$col_roles} and \verb{$col_info}.
}
}

\examples{
# we use the inherited class TaskClassif here,
# Class Task is not intended for direct use
task = TaskClassif$new("penguings", palmerpenguins::penguins, target = "species")

task$nrow
task$ncol
task$feature_names
task$formula()

# de-select "year"
task$select(setdiff(task$feature_names, "year"))

task$feature_names

# Add new column "foo"
task$cbind(data.frame(foo = 1:344))
task$head()
}
\seealso{
Other Task: 
\code{\link{TaskClassif}},
\code{\link{TaskRegr}},
\code{\link{TaskSupervised}},
\code{\link{TaskUnsupervised}},
\code{\link{mlr_tasks_boston_housing}},
\code{\link{mlr_tasks_breast_cancer}},
\code{\link{mlr_tasks_german_credit}},
\code{\link{mlr_tasks_iris}},
\code{\link{mlr_tasks_mtcars}},
\code{\link{mlr_tasks_penguins}},
\code{\link{mlr_tasks_pima}},
\code{\link{mlr_tasks_sonar}},
\code{\link{mlr_tasks_spam}},
\code{\link{mlr_tasks_wine}},
\code{\link{mlr_tasks_zoo}},
\code{\link{mlr_tasks}}
}
\concept{Task}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of the object.
Used in tables, plot and text output.}

\item{\code{task_type}}{(\code{character(1)})\cr
Task type, e.g. \code{"classif"} or \code{"regr"}.

For a complete list of possible task types (depending on the loaded packages),
see \code{\link[=mlr_reflections]{mlr_reflections$task_types$type}}.}

\item{\code{backend}}{(\link{DataBackend})\cr
Abstract interface to the data of the task.}

\item{\code{col_info}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Table with with 3 columns:
\itemize{
\item \code{"id"} (\code{character()}) stores the name of the column.
\item \code{"type"} (\code{character()}) holds the storage type of the variable, e.g. \code{integer}, \code{numeric} or \code{character}.
See \link[=mlr_reflections]{mlr_reflections$task_feature_types} for a complete list of allowed types.
\item \code{"levels"} stores a vector of distinct values (levels) for ordered and unordered factor variables.
}}

\item{\code{man}}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
Defaults to \code{NA}, but can be set by child classes.}

\item{\code{extra_args}}{(named \code{list()})\cr
Additional arguments set during construction.
Required for \code{\link[=convert_task]{convert_task()}}.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{hash}}{(\code{character(1)})\cr
Hash (unique identifier) for this object.}

\item{\code{row_ids}}{(\code{integer()})\cr
Returns the row ids of the \link{DataBackend} for observations with role "use".}

\item{\code{row_names}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Returns a table with two columns:
\itemize{
\item \code{"row_id"} (\code{integer()}), and
\item \code{"row_name"} (\code{character()}).
}}

\item{\code{feature_names}}{(\code{character()})\cr
Returns all column names with \code{role == "feature"}.

Note that this vector determines the default order of columns for \code{task$data(cols = NULL, ...)}.
However, it is recommended to \strong{not} rely on the order of columns, but instead always
address columns by their name. The default order is not well defined after some
operations, e.g. after \code{task$cbind()} or after processing via \CRANpkg{mlr3pipelines}.}

\item{\code{target_names}}{(\code{character()})\cr
Returns all column names with role "target".}

\item{\code{properties}}{(\code{character()})\cr
Set of task properties.
Possible properties are are stored in \link[=mlr_reflections]{mlr_reflections$task_properties}.
The following properties are currently standardized and understood by tasks in \CRANpkg{mlr3}:
\itemize{
\item \code{"strata"}: The task is resampled using one or more stratification variables (role \code{"stratum"}).
\item \code{"groups"}: The task comes with grouping/blocking information (role \code{"group"}).
\item \code{"weights"}: The task comes with observation weights (role \code{"weight"}).
}

Note that above listed properties are calculated from the \verb{$col_roles} and may not be set explicitly.}

\item{\code{row_roles}}{(named \code{list()})\cr
Each row (observation) can have an arbitrary number of roles in the learning task:
\itemize{
\item \code{"use"}: Use in train / predict / resampling.
\item \code{"validation"}: Observations are hold back unless explicitly requested.
Can be used as truly independent test set.
}

\code{row_roles} is a named list whose elements are named by row role and each element is an \code{integer()} vector of row ids.
To alter the roles, just modify the list, e.g. with  \R's set functions (\code{\link[=intersect]{intersect()}}, \code{\link[=setdiff]{setdiff()}}, \code{\link[=union]{union()}}, \ldots).}

\item{\code{col_roles}}{(named \code{list()})\cr
Each column (feature) can have an arbitrary number of the following roles:
\itemize{
\item \code{"feature"}: Regular feature used in the model fitting process.
\item \code{"target"}: Target variable.
\item \code{"name"}: Row names / observation labels. To be used in plots. Can be queried with \verb{$row_names}.
\item \code{"order"}: Data returned by \verb{$data()} is ordered by this column (or these columns).
\item \code{"group"}: During resampling, observations with the same value of the variable with role "group" are marked as "belonging together".
For each resampling iteration, observations of the same group will be exclusively assigned to be either in the training set or in the test set.
Note that only up to one column may have this role.
\item \code{"stratum"}: Stratification variables. Multiple discrete columns may have this role.
\item \code{"weight"}: Observation weights. Only up to one column (assumed to be discrete) may have this role.
\item \code{"uri"}: URI pointing to an external resource, e.g., images on the file system.
}

\code{col_roles} is a named list whose elements are named by column role and each element is a \code{character()} vector of column names.
To alter the roles, just modify the list, e.g. with \R's set functions (\code{\link[=intersect]{intersect()}}, \code{\link[=setdiff]{setdiff()}}, \code{\link[=union]{union()}}, \ldots).
The method \verb{$set_col_roles} provides a convenient alternative to assign columns to roles.}

\item{\code{nrow}}{(\code{integer(1)})\cr
Returns the total number of rows with role "use".}

\item{\code{ncol}}{(\code{integer(1)})\cr
Returns the total number of columns with role "target" or "feature".}

\item{\code{feature_types}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Returns a table with columns \code{id} and \code{type} where \code{id} are the column names of "active"
features of the task and \code{type} is the storage type.}

\item{\code{data_formats}}{\code{character()}\cr
Vector of supported data output formats.
A specific format can be chosen in the \verb{$data()} method.}

\item{\code{strata}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
If the task has columns designated with role \code{"stratum"}, returns a table with one subpopulation per row and two columns:
\itemize{
\item \code{N} (\code{integer()}) with the number of observations in the subpopulation, and
\item \code{row_id} (list of \code{integer()}) as list column with the row ids in the respective subpopulation.
Returns \code{NULL} if there are is no stratification variable.
See \link{Resampling} for more information on stratification.
}}

\item{\code{groups}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
If the task has a column with designated role \code{"group"}, a table with two columns:
\itemize{
\item \code{row_id} (\code{integer()}), and
\item grouping variable \code{group} (\code{vector()}).
}

Returns \code{NULL} if there are is no grouping column.
See \link{Resampling} for more information on grouping.}

\item{\code{order}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
If the task has at least one column with designated role \code{"order"}, a table with two columns:
\itemize{
\item \code{row_id} (\code{integer()}), and
\item ordering vector \code{order} (\code{integer()}).
}

Returns \code{NULL} if there are is no order column.}

\item{\code{weights}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
If the task has a column with designated role \code{"weight"}, a table with two columns:
\itemize{
\item \code{row_id} (\code{integer()}), and
\item observation weights \code{weight} (\code{numeric()}).
}

Returns \code{NULL} if there are is no weight column.}

\item{\code{uris}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
If the task has a column with designated role \code{"uri"}, a table with two columns:
\itemize{
\item \code{row_id} (\code{integer()}), and
\item \code{uri} (\code{character()}).
}

Returns \code{NULL} if there are is no uri column.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Task$new()}}
\item \href{#method-help}{\code{Task$help()}}
\item \href{#method-format}{\code{Task$format()}}
\item \href{#method-print}{\code{Task$print()}}
\item \href{#method-data}{\code{Task$data()}}
\item \href{#method-formula}{\code{Task$formula()}}
\item \href{#method-head}{\code{Task$head()}}
\item \href{#method-levels}{\code{Task$levels()}}
\item \href{#method-missings}{\code{Task$missings()}}
\item \href{#method-filter}{\code{Task$filter()}}
\item \href{#method-select}{\code{Task$select()}}
\item \href{#method-rbind}{\code{Task$rbind()}}
\item \href{#method-cbind}{\code{Task$cbind()}}
\item \href{#method-rename}{\code{Task$rename()}}
\item \href{#method-set_row_roles}{\code{Task$set_row_roles()}}
\item \href{#method-set_col_roles}{\code{Task$set_col_roles()}}
\item \href{#method-droplevels}{\code{Task$droplevels()}}
\item \href{#method-clone}{\code{Task$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.

Note that this object is typically constructed via a derived classes, e.g. \link{TaskClassif} or \link{TaskRegr}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$new(id, task_type, backend, extra_args = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier for the new instance.}

\item{\code{task_type}}{(\code{character(1)})\cr
Type of task, e.g. \code{"regr"} or \code{"classif"}.
Must be an element of \link[=mlr_reflections]{mlr_reflections$task_types$type}.}

\item{\code{backend}}{(\link{DataBackend})\cr
Either a \link{DataBackend}, or any object which is convertible to a \link{DataBackend} with \code{as_data_backend()}.
E.g., a \code{data.frame()} will be converted to a \link{DataBackendDataTable}.}

\item{\code{extra_args}}{(named \code{list()})\cr
Named list of constructor arguments, required for converting task types
via \code{\link[=convert_task]{convert_task()}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-help"></a>}}
\if{latex}{\out{\hypertarget{method-help}{}}}
\subsection{Method \code{help()}}{
Opens the corresponding help page referenced by field \verb{$man}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$help()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-format"></a>}}
\if{latex}{\out{\hypertarget{method-format}{}}}
\subsection{Method \code{format()}}{
Helper for print outputs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$format()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Printer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(ignored).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-data"></a>}}
\if{latex}{\out{\hypertarget{method-data}{}}}
\subsection{Method \code{data()}}{
Returns a slice of the data from the \link{DataBackend} in the data format specified by \code{data_format}.
Rows default to observations with role \code{"use"}, and
columns default to features with roles \code{"target"} or \code{"feature"}.
If \code{rows} or \code{cols} are specified which do not exist in the \link{DataBackend},
an exception is raised.

Rows and columns are returned in the order specified via the arguments \code{rows} and \code{cols}.
If \code{rows} is \code{NULL}, rows are returned in the order of \code{task$row_ids}.
If \code{cols} is \code{NULL}, the column order defaults to
\code{c(task$target_names, task$feature_names)}.
Note that it is recommended to \strong{not} rely on the order of columns, and instead always
address columns with their respective column name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$data(rows = NULL, cols = NULL, data_format = "data.table", ordered = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows}}{\code{integer()}\cr
Row indices.}

\item{\code{cols}}{\code{character()}\cr
Column names.}

\item{\code{data_format}}{(\code{character(1)})\cr
Desired data format, e.g. \code{"data.table"} or \code{"Matrix"}.}

\item{\code{ordered}}{(\code{logical(1)})\cr
If \code{TRUE} (default), data is ordered according to the columns with column role \code{"order"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Depending on the \link{DataBackend}, but usually a \code{\link[data.table:data.table]{data.table::data.table()}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-formula"></a>}}
\if{latex}{\out{\hypertarget{method-formula}{}}}
\subsection{Method \code{formula()}}{
Constructs a \code{\link[=formula]{formula()}}, e.g. \verb{[target] ~ [feature_1] + [feature_2] + ... + [feature_k]},
using the features provided in argument \code{rhs} (defaults to all columns with role \code{"feature"}, symbolized by \code{"."}).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$formula(rhs = ".")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rhs}}{(\code{character(1)})\cr
Right hand side of the formula. Defaults to \code{"."} (all features of the task).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[=formula]{formula()}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-head"></a>}}
\if{latex}{\out{\hypertarget{method-head}{}}}
\subsection{Method \code{head()}}{
Get the first \code{n} observations with role \code{"use"} of all columns with role \code{"target"} or \code{"feature"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$head(n = 6L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{(\code{integer(1)}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}} with \code{n} rows.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-levels"></a>}}
\if{latex}{\out{\hypertarget{method-levels}{}}}
\subsection{Method \code{levels()}}{
Returns the distinct values for columns referenced in \code{cols} with storage type "factor" or "ordered".
Argument \code{cols} defaults to all such columns with role \code{"target"} or \code{"feature"}.

Note that this function ignores the row roles, it returns all levels available in the \link{DataBackend}.
To update the stored level information, e.g. after subsetting a task with \verb{$filter()}, call \verb{$droplevels()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$levels(cols = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cols}}{\code{character()}\cr
Column names.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
named \code{list()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-missings"></a>}}
\if{latex}{\out{\hypertarget{method-missings}{}}}
\subsection{Method \code{missings()}}{
Returns the number of missing observations for columns referenced in \code{cols}.
Considers only active rows with row role \code{"use"}.
Argument \code{cols} defaults to all columns with role "target" or "feature".
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$missings(cols = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cols}}{\code{character()}\cr
Column names.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Named \code{integer()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-filter"></a>}}
\if{latex}{\out{\hypertarget{method-filter}{}}}
\subsection{Method \code{filter()}}{
Subsets the task, keeping only the rows specified via row ids \code{rows}.

This operation mutates the task in-place.
See the section on task mutators for more information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$filter(rows)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows}}{\code{integer()}\cr
Row indices.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns the object itself, but modified \strong{by reference}.
You need to explicitly \verb{$clone()} the object beforehand if you want to keeps
the object in its previous state.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-select"></a>}}
\if{latex}{\out{\hypertarget{method-select}{}}}
\subsection{Method \code{select()}}{
Subsets the task, keeping only the features specified via column names \code{cols}.
Note that you cannot deselect the target column, for obvious reasons.

This operation mutates the task in-place.
See the section on task mutators for more information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$select(cols)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cols}}{\code{character()}\cr
Column names.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns the object itself, but modified \strong{by reference}.
You need to explicitly \verb{$clone()} the object beforehand if you want to keeps
the object in its previous state.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rbind"></a>}}
\if{latex}{\out{\hypertarget{method-rbind}{}}}
\subsection{Method \code{rbind()}}{
Adds additional rows to the \link{DataBackend} stored in \verb{$backend}.
New row ids are automatically created, unless \code{data} has a column whose name matches
the primary key of the \link{DataBackend} (\code{task$backend$primary_key}).
In case of name clashes of row ids, rows in \code{data} have higher precedence
and virtually overwrite the rows in the \link{DataBackend}.

All columns with the roles \code{"target"}, \code{"feature"}, \code{"weight"}, \code{"group"}, \code{"stratum"}, and \code{"order"} must be present in \code{data}.
Columns only present in \code{data} but not in the \link{DataBackend} of \code{task} will be discarded.

This operation mutates the task in-place.
See the section on task mutators for more information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$rbind(data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{(\code{data.frame()}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns the object itself, but modified \strong{by reference}.
You need to explicitly \verb{$clone()} the object beforehand if you want to keeps
the object in its previous state.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cbind"></a>}}
\if{latex}{\out{\hypertarget{method-cbind}{}}}
\subsection{Method \code{cbind()}}{
Adds additional columns to the \link{DataBackend} stored in \verb{$backend}.

The row ids must be provided as column in \code{data} (with column name matching the primary key name of the \link{DataBackend}).
If this column is missing, it is assumed that the rows are exactly in the order of \verb{$row_ids}.
In case of name clashes of column names in \code{data} and \link{DataBackend}, columns in \code{data} have higher precedence
and virtually overwrite the columns in the \link{DataBackend}.

This operation mutates the task in-place.
See the section on task mutators for more information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$cbind(data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{(\code{data.frame()}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rename"></a>}}
\if{latex}{\out{\hypertarget{method-rename}{}}}
\subsection{Method \code{rename()}}{
Renames columns by mapping column names in \code{old} to new column names in \code{new} (element-wise).

This operation mutates the task in-place.
See the section on task mutators for more information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$rename(old, new)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{old}}{(\code{character()})\cr
Old names.}

\item{\code{new}}{(\code{character()})\cr
New names.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns the object itself, but modified \strong{by reference}.
You need to explicitly \verb{$clone()} the object beforehand if you want to keeps
the object in its previous state.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_row_roles"></a>}}
\if{latex}{\out{\hypertarget{method-set_row_roles}{}}}
\subsection{Method \code{set_row_roles()}}{
Modifies the roles in \verb{$row_roles} \strong{in-place}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$set_row_roles(rows, roles = NULL, add_to = NULL, remove_from = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows}}{(\code{integer()})\cr
Row ids for which to change the roles for.}

\item{\code{roles}}{(\code{character()})\cr
Exclusively set rows to the specified \code{roles} (remove from other roles).}

\item{\code{add_to}}{(\code{character()})\cr
Add rows with row ids \code{rows} to roles specified in \code{add_to}.
Rows keep their previous roles.}

\item{\code{remove_from}}{(\code{character()})\cr
Remove rows with row ids \code{rows} from roles specified in \code{remove_from}.
Other row roles are preserved.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Roles are first set exclusively (argument \code{roles}), then added (argument \code{add_to}) and finally
removed (argument \code{remove_from}) from different roles.
}

\subsection{Returns}{
Returns the object itself, but modified \strong{by reference}.
You need to explicitly \verb{$clone()} the object beforehand if you want to keeps
the object in its previous state.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_col_roles"></a>}}
\if{latex}{\out{\hypertarget{method-set_col_roles}{}}}
\subsection{Method \code{set_col_roles()}}{
Modifies the roles in \verb{$col_roles} \strong{in-place}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$set_col_roles(cols, roles = NULL, add_to = NULL, remove_from = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cols}}{(\code{character()})\cr
Column names for which to change the roles for.}

\item{\code{roles}}{(\code{character()})\cr
Exclusively set columns to the specified \code{roles} (remove from other roles).}

\item{\code{add_to}}{(\code{character()})\cr
Add columns with column names \code{cols} to roles specified in \code{add_to}.
Columns keep their previous roles.}

\item{\code{remove_from}}{(\code{character()})\cr
Remove columns with columns names \code{cols} from roles specified in \code{remove_from}.
Other column roles are preserved.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Roles are first set exclusively (argument \code{roles}), then added (argument \code{add_to}) and finally
removed (argument \code{remove_from}) from different roles.
}

\subsection{Returns}{
Returns the object itself, but modified \strong{by reference}.
You need to explicitly \verb{$clone()} the object beforehand if you want to keeps
the object in its previous state.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-droplevels"></a>}}
\if{latex}{\out{\hypertarget{method-droplevels}{}}}
\subsection{Method \code{droplevels()}}{
Updates the cache of stored factor levels, removing all levels not present in the current set of active rows.
\code{cols} defaults to all columns with storage type "factor" or "ordered".
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$droplevels(cols = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cols}}{\code{character()}\cr
Column names.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Modified \code{self}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
