% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateBenchmarkSummary.R
\name{generateBenchmarkSummaryData}
\alias{generateBenchmarkSummaryData}
\title{Generate data for a benchmark-summary plot.}
\usage{
generateBenchmarkSummaryData(bmr, measure = NULL, fill = "best",
  order.lrns = NULL, order.tsks = NULL)
}
\arguments{
\item{bmr}{[\code{\link{BenchmarkResult}}]\cr
Benchmark result.}

\item{measure}{[\code{\link{Measure}}]\cr
Performance measure.
Default is the default measure for the task, see here \code{\link{getDefaultMeasure}}.}

\item{fill}{[\code{character(0)}] \cr
Bars are filled proportional to \dQuote{best} or \dQuote{worst} performing
algorithm. \cr
\dQuote{best} compares all performances to the best performance accross all
classifiers. Bars are filled proportional to the best performance. \cr
\dQuote{worst} compares all performances to the worst performance accross
all classifiers. Bars are filled proportional to the worst performance. \cr}

\item{order.lrns}{[\code{character(n.learners)}]\cr 
Character vector with \code{learner.ids} in new order.}

\item{order.tsks}{[\code{character(n.tasks)}] \cr 
Character vector with \code{task.ids} in new order.}
}
\value{
\code{BenchmarkSummaryData}. List containing:
\item{data}{[\code{data.frame}]}
\item{fill}{selected \code{fill} option}
\item{measure}{selected \code{measure}}
}
\description{
A benchmark-summary plot allows comparison of performance of different
learners within a task.
}
\seealso{
Other benchmark: \code{\link{BenchmarkResult}},
  \code{\link{benchmark}},
  \code{\link{convertBMRToRankMatrix}},
  \code{\link{friedmanPostHocTestBMR}},
  \code{\link{friedmanTestBMR}},
  \code{\link{generateCritDifferencesData}},
  \code{\link{generateRankMatrixAsBarData}},
  \code{\link{getBMRAggrPerformances}},
  \code{\link{getBMRFeatSelResults}},
  \code{\link{getBMRFilteredFeatures}},
  \code{\link{getBMRLearnerIds}},
  \code{\link{getBMRLearners}},
  \code{\link{getBMRMeasureIds}},
  \code{\link{getBMRMeasures}},
  \code{\link{getBMRPerformances}},
  \code{\link{getBMRPredictions}},
  \code{\link{getBMRTaskIds}},
  \code{\link{getBMRTuneResults}},
  \code{\link{plotBenchmarkResult}},
  \code{\link{plotBenchmarkSummary}},
  \code{\link{plotCritDifferences}},
  \code{\link{plotRankMatrixAsBar}}

Other generate_plot_data: \code{\link{generateCalibrationData}},
  \code{\link{generateCritDifferencesData}},
  \code{\link{generateFilterValuesData}},
  \code{\link{generateLearningCurveData}},
  \code{\link{generatePartialPredictionData}},
  \code{\link{generateROCRCurvesData}},
  \code{\link{generateRankMatrixAsBarData}},
  \code{\link{generateThreshVsPerfData}},
  \code{\link{getFilterValues}}
}

