% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations_data.R
\name{simulations_data}
\alias{simulations_data}
\title{Display info on the generated data}
\usage{
simulations_data(ds)
}
\arguments{
\item{ds}{Object of class designresult as created by the find.design function}
}
\value{
A data frame
}
\description{
Output a data frame that, for each set of design parameters, includes the cost, the estimated power and SE, the surrogate model estimated power and SE, and the number of performed evaluations.
}
\details{
The raw power is estimated using the ratio of significant hypothesis tests among the performed evaluations. The raw SE is estimated using \eqn{p(1-p)/n} with \eqn{p} being the raw power and \eqn{n} being the number of performed evaluations.

For the estimation of SE using a surrogate model, GPR is employed because it is capable of variance estimation, unlike the other surrogate models.
}
\examples{

# Load a simulation function
simfun <- example.simfun('ttest')
# Perform the search
ds <- find.design(simfun = simfun, boundaries = c(100,300), power = .95)
# Display more info on the collected data
simulations_data(ds)

}
