% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmm_generate.R
\name{hmm_generate}
\alias{hmm_generate}
\title{Hidden Markov Model (HMM) Sequence Generator}
\usage{
hmm_generate(length, model, seed = NA, start_state = NA, verbose = FALSE)
}
\arguments{
\item{length}{Length of sequence to generate (integer).}

\item{model}{Trained HMM to generate sequences with (HMMModel).}

\item{seed}{Random seed.  If 0, 'std::time(NULL)' is used.  Default
value "0" (integer).}

\item{start_state}{Starting state of sequence.  Default value "0"
(integer).}

\item{verbose}{Display informational messages and the full list of
parameters and timers at the end of execution.  Default value "FALSE"
(logical).}
}
\value{
A list with several components:
\item{output}{Matrix to save observation sequence to (numeric matrix).}
\item{state}{Matrix to save hidden state sequence to (integer matrix).}
}
\description{
A utility to generate random sequences from a pre-trained Hidden Markov Model
(HMM).  The length of the desired sequence can be specified, and a random
sequence of observations is returned.
}
\details{
This utility takes an already-trained HMM, specified as the "model"
parameter, and generates a random observation sequence and hidden state
sequence based on its parameters. The observation sequence may be saved with
the "output" output parameter, and the internal state  sequence may be saved
with the "state" output parameter.

The state to start the sequence in may be specified with the "start_state"
parameter.
}
\examples{
# For example, to generate a sequence of length 150 from the HMM "hmm" and
# save the observation sequence to "observations" and the hidden state
# sequence to "states", the following command may be used: 

\dontrun{
output <- hmm_generate(model=hmm, length=150)
observations <- output$output
states <- output$state
}
}
\author{
mlpack developers
}
