#'
#' @title ERing
#' @description Multivariate time series (MTS) indicating the movement of the worm Caenorhabditis elegans. The motion of worms
#' in an agar plate is recorded as a combination of six base shapes.
#' @usage data(ERing)
#' @format A \code{list} with two elements, which are:
#' \describe{
#' \item{\code{data}}{A list with 60 MTS.}
#' \item{\code{classes}}{A numeric vector indicating the corresponding classes associated with the elements in \code{data}.}
#' }
#' @details Each element in \code{data} is a matrix formed by 65 rows (time points) indicating time measurements and 4 columns (variables) indicating electrodes. The first 30 elements
#' correspond to the training set, whereas the last 30 elements correspond to the test set. The numeric vector \code{classes} is formed
#' by integers from 1 to 6, indicating that there are 6 different classes in the database. Each class is associated with a different
#' posture of the hand. For more information, see \insertCite{bagnall2018uea;textual}{mlmts}.
#' @references{
#'
#'   \insertRef{bagnall2018uea}{mlmts}
#'
#'   \insertRef{ruiz2021great}{mlmts}
#'
#'   \insertRef{bagnallweb}{mlmts}
#'
#' }
"ERing"

