% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samples.R
\docType{data}
\name{samples}
\alias{samples}
\title{Water-Quality Samples}
\format{
A data frame with the following variables:
\describe{
\item{\code{site_nm}}{Local site name for a MLMS well.}
\item{\code{port_nu}}{Identifier for the valved measurement port.}
\item{\code{site_no}}{USGS site identification number for a MLMS measurement port.}
\item{\code{stime_dt}}{Start time for the pressure profiling event.}
\item{\code{sample_dt}}{Date and time the water-quality sample was collected, in "America/Denver" time zone.
Missing values of time were substituted with "12:00".}
\item{\code{parm_short_nm}}{Parameter short name assigned by the USGS, such as "pH";
followed by 'wu' water, unfiltered or 'wf' water, filtered.}
\item{\code{unit_cd}}{Units of measurement.}
\item{\code{pcode}}{USGS 5-digit parameter code. For example, the parameter code for Tritium is "07000".}
\item{\code{remark_cd}}{Remark code (result level) used to qualify the parameter value.
The codes and their meanings are as follows: \code{\link{NA}} (missing value) is a quantified value;
"<" is where the actual value is known to be less than the value reported, that is,
the measured concentration is below the reporting limit (RL) and represented as
a censored (or nondetection) value. For censored values, the value reported is the RL;
and "E" is an estimated value, that is, the actual value is greater than the
minimum detection limit (MDL) and less than the laboratory reporting level (LRL).
}
\item{\code{result_va}}{Parameter value.}
\item{\code{lab_li_va}}{Lower confidence interval of the result value based on laboratory analysis.}
\item{\code{lab_ui_va}}{Upper confidence interval of the result value based on laboratory analysis.}
\item{\code{dqi_cd}}{Data quality indicator code that indicates the review status of a result.
The codes and their meanings are as follows: "R" reviewed and accepted,
and "S" provisional (presumed satisfactory).}
\item{\code{sample_type_cd}}{Sample type code that identifies the quality-assurance (QA) type of a sample.
The codes and their meanings are as follows:
"2" is a blank sample;
"7" is a replicate sample taken from the environment; and
"9" is a regular sample taken from the environment.}
}
}
\source{
Sample data retrieved from the \pkg{inldata} package using the \code{\link{get_samples}} function.
}
\usage{
samples
}
\description{
Depth-discrete chemical and physical data for groundwater collected from
Multilevel Monitoring System (MLMS) wells in the U.S. Geological Survey (USGS)
aquifer-monitoring network, Idaho National Laboratory (INL), Idaho.
}
\examples{
str(samples)
}
\keyword{datasets}
