% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{Variables}
\alias{Variables}
\alias{variables}
\alias{variable}
\alias{mp_variable}
\alias{outcome}
\alias{within_predictor}
\alias{within_time_predictor}
\alias{between_predictor}
\alias{between_binary_predictor}
\title{Functions for Creating Variables}
\usage{
outcome(name, mean = 10, sd = 5, icc = NULL)

within_predictor(name, weight = 1, mean = 0, sd = 1, icc = NULL)

within_time_predictor(name, values, weight = 1)

between_predictor(name, weight = 1, mean = 0, sd = 1)

between_binary_predictor(name, proportion = 0.5, weight = 1)
}
\arguments{
\item{name}{a character string for the specific variable's name}

\item{mean}{a single numeric value that specifies the variable's mean}

\item{sd}{a single numeric value that specifies the variable's standard deviation}

\item{icc}{a single numeric value between 0 and 1 that specifies the variable's intraclass correlation.
If \code{NULL} then the global ICC specified in \code{\link[=effect_size]{effect_size()}} is used instead.}

\item{weight}{a single numeric value specifying the variable's contribution to the variance explained metric.
Weights are normalized across all variables of the same level.}

\item{values}{a numeric vector specifying the time scores that will be repeated within each cluster.}

\item{proportion}{a single numeric value between 0 and 1 that specifies the proportion of 1's at the population.}
}
\value{
Returns a \code{mp_variable} object based on the variable's type.
}
\description{
These functions are the building blocks used to create the multilevel model
and are used to specify the names, properties, and variable types.
}
\details{
Note that specifying an \code{icc = 0} in \code{within_predictor()}
will result in a centered within cluster (CWC) predictor.

See vignettes for more details.

\if{html}{\out{<div class="sourceCode">}}\preformatted{vignette(package = 'mlmpower')
}\if{html}{\out{</div>}}
}
