% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learner_rpart.R
\name{LearnerRpart}
\alias{LearnerRpart}
\title{LearnerRpart R6 class}
\description{
This learner is a wrapper around \code{\link[rpart:rpart]{rpart::rpart()}} in order to fit recursive
partitioning and regression trees.
}
\details{
Optimization metric:
\itemize{
\item classification (\code{method = "class"}): classification error rate
\item regression (\code{method = "anova"}): mean squared error
}

Can be used with
\itemize{
\item \link{MLTuneParameters}
\item \link{MLCrossValidation}
\item \link{MLNestedCV}
}

Implemented methods:
\itemize{
\item \verb{$fit} To fit the model.
\item \verb{$predict} To predict new data with the model.
\item \verb{$cross_validation} To perform a grid search (hyperparameter
optimization).
\item \verb{$bayesian_scoring_function} To perform a Bayesian hyperparameter
optimization.
}

Parameters that are specified with \code{parameter_grid} and / or \code{learner_args}
are forwarded to \code{rpart}'s argument \code{control} (see
\code{\link[rpart:rpart.control]{rpart::rpart.control()}} for further details).

For the two hyperparameter optimization strategies ("grid" and "bayesian"),
the parameter \code{metric_optimization_higher_better} of the learner is
set to \code{FALSE} by default as the mean misclassification error rate
(\code{\link[measures:MMCE]{measures::MMCE()}}) is used as the optimization metric for
classification tasks and the mean squared error (\code{\link[measures:MSE]{measures::MSE()}}) is
used for regression tasks.
}
\examples{
LearnerRpart$new()


## ------------------------------------------------
## Method `LearnerRpart$new`
## ------------------------------------------------

LearnerRpart$new()

}
\seealso{
\code{\link[rpart:rpart]{rpart::rpart()}}, \code{\link[measures:MMCE]{measures::MMCE()}}, [measures::MSE)],
[rpart::rpart.control()]

[measures::MSE)]: R:measures::MSE)
[rpart::rpart.control()]: R:rpart::rpart.control()

\code{\link[rpart:rpart]{rpart::rpart()}}, \code{\link[measures:MMCE]{measures::MMCE()}}, \code{\link[measures:MSE]{measures::MSE()}}
}
\section{Super class}{
\code{\link[mlexperiments:MLLearnerBase]{mlexperiments::MLLearnerBase}} -> \code{LearnerRpart}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerRpart-new}{\code{LearnerRpart$new()}}
\item \href{#method-LearnerRpart-clone}{\code{LearnerRpart$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="bayesian_scoring_function"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-bayesian_scoring_function'><code>mlexperiments::MLLearnerBase$bayesian_scoring_function()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="cross_validation"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-cross_validation'><code>mlexperiments::MLLearnerBase$cross_validation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="fit"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-fit'><code>mlexperiments::MLLearnerBase$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="predict"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-predict'><code>mlexperiments::MLLearnerBase$predict()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRpart-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRpart-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{LearnerRpart} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRpart$new()}\if{html}{\out{</div>}}
}

\subsection{Details}{
This learner is a wrapper around \code{\link[rpart:rpart]{rpart::rpart()}} in order to fit
recursive partitioning and regression trees. The following experiments
are implemented:
\itemize{
\item \link{MLTuneParameters}
\item \link{MLCrossValidation}
\item \link{MLNestedCV}
}

For the two hyperparameter optimization strategies ("grid" and
"bayesian"), the parameter \code{metric_optimization_higher_better} of the
learner is set to \code{FALSE} by default as the mean misclassification
error (\code{\link[measures:MMCE]{measures::MMCE()}}) is used as the optimization metric for
classification tasks and the mean squared error (\code{\link[measures:MSE]{measures::MSE()}})
is used for regression tasks.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{LearnerRpart$new()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRpart-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRpart-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRpart$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
