% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_payload.R
\name{get_payload}
\alias{get_payload}
\title{Get Gameday data from MLBAM.}
\usage{
get_payload(start = NULL, end = NULL, league = "mlb", dataset = NULL,
  game_ids = NULL, db_con = NULL, ...)
}
\arguments{
\item{start}{A start date passed as a character in ISO 8601 format. \code{"2017-05-01"}}

\item{end}{An end date passed as a character in ISO 8601 format. \code{"2017-09-01"}}

\item{league}{The league to gather gids for. The default is \code{"mlb"}. Other options include \code{"aaa"} and \code{"aa"}}

\item{dataset}{The dataset to be scraped. The default is "inning_all." Other options include, "inning_hit", "linescore".}

\item{game_ids}{A list of user-supplied gameIds.}

\item{db_con}{A database connection from the \code{DBI} package.}

\item{...}{additional arguments}
}
\description{
Get Gameday data from MLBAM.
}
\examples{

\dontrun{
# Make a request for a single day.
df <- get_payload(start = "2016-06-01", end = "2016-06-01")


# Run larger requests in parallel.
library(doParallel)
library(foreach)

no_cores <- detectCores() - 2
cl <- makeCluster(no_cores) 
registerDoParallel(cl)

df <- get_payload(start = "2016-01-01", end = "2017-01-01")

stopImplicitCluster()
rm(cl)

}

# Supply your own custom vector of game ids.

mygids <- search_gids(team = "indians", start = "2016-05-01", end = "2016-05-01")

df <- get_payload(game_ids = mygids)


}
