% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ilr.R
\name{ilr}
\alias{ilr}
\alias{invilr}
\title{Function to perform isometric log-ratio transformation}
\usage{
ilr(x)

invilr(x)
}
\arguments{
\item{x}{A numeric vector. Naturally, the forward transformation is only
sensible for vectors with all elements being greater than zero.}
}
\value{
The result of the forward or backward transformation. The returned
components always sum to 1 for the case of the inverse log-ratio
transformation.
}
\description{
This implementation is a special case of the class of isometric log-ratio
transformations.
}
\examples{

# Order matters
ilr(c(0.1, 1, 10))
ilr(c(10, 1, 0.1))
# Equal entries give ilr transformations with zeros as elements
ilr(c(3, 3, 3))
# Almost equal entries give small numbers
ilr(c(0.3, 0.4, 0.3))
# Only the ratio between the numbers counts, not their sum
invilr(ilr(c(0.7, 0.29, 0.01)))
invilr(ilr(2.1 * c(0.7, 0.29, 0.01)))
# Inverse transformation of larger numbers gives unequal elements
invilr(-10)
invilr(c(-10, 0))
# The sum of the elements of the inverse ilr is 1
sum(invilr(c(-10, 0)))
# This is why we do not need all elements of the inverse transformation to go back:
a <- c(0.1, 0.3, 0.5)
b <- invilr(a)
length(b) # Four elements
ilr(c(b[1:3], 1 - sum(b[1:3]))) # Gives c(0.1, 0.3, 0.5)

}
\references{
Peter Filzmoser, Karel Hron (2008) Outlier Detection for
Compositional Data Using Robust Methods. Math Geosci 40 233-248
}
\seealso{
Another implementation can be found in R package
\code{robCompositions}.
}
\author{
René Lehmann and Johannes Ranke
}
\keyword{manip}
