% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\name{mizerMort}
\alias{mizerMort}
\title{Get total mortality rate needed to project standard mizer model}
\usage{
mizerMort(params, n, n_pp, n_other, f_mort, pred_mort, ...)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{f_mort}{A two dimensional array (species x size) with the fishing
mortality}

\item{pred_mort}{A two dimensional array (species x size) with the predation
mortality}

\item{...}{Optional arguments for rate functions.}
}
\value{
A two dimensional array (species x size) with the total mortality
rates.
}
\description{
Calculates the total mortality rate \eqn{\mu_i(w)}  (in units 1/year) on each
species by size from predation mortality, background mortality and fishing
mortality.
}
\seealso{
Other mizer rate functions: 
\code{\link{mizerEGrowth}()},
\code{\link{mizerEReproAndGrowth}()},
\code{\link{mizerERepro}()},
\code{\link{mizerEncounter}()},
\code{\link{mizerFMortGear}()},
\code{\link{mizerFMort}()},
\code{\link{mizerFeedingLevel}()},
\code{\link{mizerPredMort}()},
\code{\link{mizerPredRate}()},
\code{\link{mizerRDI}()},
\code{\link{mizerRates}()},
\code{\link{mizerResourceMort}()}
}
\concept{mizer rate functions}
