% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_methods.R
\name{indicator_functions}
\alias{indicator_functions}
\title{Description of indicator functions}
\description{
Mizer provides a range of functions to calculate indicators
from a MizerSim object.
}
\details{
A list of available indicator functions for MizerSim objects is given in the table below
\tabular{lll}{
Function \tab Returns \tab Description \cr
\code{\link[=getProportionOfLargeFish]{getProportionOfLargeFish()}} \tab A vector with values at each time step. \tab Calculates the proportion of large fish through time. The threshold value can be specified. It is possible to calculation the proportion of large fish based on either length or weight. \cr
\code{\link[=getMeanWeight]{getMeanWeight()}} \tab A vector with values at each saved time step. \tab The mean weight of the community through time. This is calculated as the total biomass of the community divided by the total abundance. \cr
\code{\link[=getMeanMaxWeight]{getMeanMaxWeight()}} \tab Depends on the measure argument. If measure = “both” then you get a matrix with two columns, one with values by numbers, the other with values by biomass at each saved time step. If measure = “numbers” or “biomass” you get a vector of the respective values at each saved time step \tab The mean maximum weight of the community through time. This can be calculated by numbers or by biomass. See the help file for more details. \cr
\code{\link[=getCommunitySlope]{getCommunitySlope()}} \tab A data.frame with four columns: time step, slope, intercept and the coefficient of determination. \tab Calculates the slope of the community abundance spectrum through time by performing a linear regression on the logged total numerical abundance and logged body size. \cr
}
}
\seealso{
\code{\link[=summary_functions]{summary_functions()}}, \code{\link[=plotting_functions]{plotting_functions()}}
}
