% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\name{SheperdRDD}
\alias{SheperdRDD}
\title{Sheperd function to calculate density-dependent reproduction rate}
\usage{
SheperdRDD(rdi, species_params, ...)
}
\arguments{
\item{rdi}{Vector of density-independent reproduction rates \eqn{R_p} for
all species.}

\item{species_params}{A species parameter dataframe. Must contain columns
\code{sheperd_b} and \code{sheperd_c} with the parameters b and c.}

\item{...}{Unused}
}
\value{
Vector of density-dependent reproduction rates.
}
\description{
Takes the density-independent rates \eqn{R_p} of egg production and returns
reduced, density-dependent rates \eqn{R} as
\deqn{R = \frac{R_p}{1+(b\ R_p)^c}}{R = R_p / (1 + (b R_p)^c)}
}
\seealso{
Other functions calculating density-dependent reproduction rate: 
\code{\link{BevertonHoltRDD}()},
\code{\link{RickerRDD}()},
\code{\link{constantRDD}()},
\code{\link{noRDD}()}
}
\concept{functions calculating density-dependent reproduction rate}
