% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cutoff.R
\name{cutoff}
\alias{cutoff}
\title{Cut off values for VLMC like model}
\usage{
cutoff(model, ...)
}
\arguments{
\item{model}{a model.}

\item{...}{additional arguments for the cutoff function implementations}
}
\value{
a cut off value or a vector of cut off values.
}
\description{
This generic function returns one or more cut off values that are guaranteed
to have an effect on the \code{model} passed to the function when a simplification
procedure is applied (in general a tree pruning operation as provided by
\code{\link[=prune]{prune()}}).
}
\details{
The exact definition of what is a cut off value depends on the model type and
is documented in concrete implementation of the function.
}
\examples{
pc <- powerconsumption[powerconsumption$week == 5, ]
dts <- cut(pc$active_power, breaks = c(0, quantile(pc$active_power, probs = c(0.25, 0.5, 0.75, 1))))
model <- vlmc(dts)
draw(model)
model_cuts <- cutoff(model)
model_2 <- prune(model, model_cuts[2])
draw(model_2)
}
\seealso{
\code{\link[=prune]{prune()}}
}
