% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setsource.R
\name{setsource}
\alias{setsource}
\title{Set Working Directory to the Source File Location}
\usage{
setsource(path = TRUE, check = TRUE)
}
\arguments{
\item{path}{logical: if \code{TRUE} (default), the path of the source file is
shown on the console.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}
}
\value{
Returns the path of the source file location.
}
\description{
This function is used to set the working directory to the source file location
(i.e., path of the current R script) in RStudio and is equivalent to using the
menu item \code{Session - Set Working Directory - To Source File Location}.
}
\details{
The function \code{documentPath()} in the package \pkg{rstudioapi} is used to
retrieve the path of the source file. Note that the R script needs to have a
file location before this function can be used to set the working directory
to the source file location.
}
\examples{
\dontrun{

# Set working directory to the source file location
setsource()

# Set working directory to the source file location
# and assign path to an object
path <- setsource()
path
}
}
\references{
Ushey, K., Allaire, J., Wickham, H., & Ritchie, G. (2022). rstudioapi: Safely
access the RStudio API. R package version 0.14.
https://CRAN.R-project.org/package=rstudioapi
}
\seealso{
\code{\link{script.close}}, \code{\link{script.new}}, \code{\link{script.open}},
\code{\link{script.save}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
