% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eta.sq.R
\name{eta.sq}
\alias{eta.sq}
\title{Eta Squared}
\usage{
eta.sq(x, group, digits = 2, as.na = NULL, check = TRUE, output = TRUE)
}
\arguments{
\item{x}{a numeric vector, matrix or data frame with numeric vectors for the outcome variables.}

\item{group}{a vector, matrix or data frame with integer vectors, character vectors or factors
for the grouping variables.}

\item{digits}{an integer value indicating the number of decimal places  to be used for displaying
eta squared.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting the analysis.
Note that \code{as.na()} function is only applied to the argument \code{x}.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{output}{logical: if \code{TRUE}, output is shown on the console.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following entries:
function call (\code{call}), matrix or data frame specified in \code{x} (\code{data}), specification of
function arguments (\code{args}), and list with results (\code{result}).
}
\description{
This function computes eta squared for one or more outcome variables in combination with one or more
grouping variables.
}
\examples{
dat <- data.frame(x1 = c(1, 1, 1, 1, 2, 2, 2, 2, 2),
                  x2 = c(1, 1, 1, 2, 2, 2, 3, 3, 3),
                  y1 = c(3, 2, 4, 5, 6, 4, 7, 5, 7),
                  y2 = c(2, 4, 1, 5, 3, 3, 4, 6, 7))

# Eta squared for y1 explained by x1
eta.sq(dat$y1, group = dat$x1)

# Eta squared for y1 and y2 explained by x1 and x2
eta.sq(dat[, c("y1", "y2")], group = dat[, c("x1", "x2")])
}
\references{
Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
New York: John Wiley & Sons.
}
\seealso{
\code{\link{cohens.d}}, \code{\link{cor.cont}}, \code{\link{cor.matrix}},
\code{\link{cor.cramer}}, \code{\link{cor.phi}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
