% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/script.close.R
\name{script.close}
\alias{script.close}
\title{Close R Script in RStudio}
\usage{
script.close(save = FALSE, check = TRUE)
}
\arguments{
\item{save}{logical: if \code{TRUE}, the script is saved before closing.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}
}
\description{
This function is used to close the current R script in RStudio. Note that by
default the function closes the script without saving unless the argument
\code{save} is set to \code{TRUE}.
}
\details{
The function \code{documentClose()} in the package \pkg{rstudioapi} is used
to close the R script.
}
\examples{
\dontrun{

# Close current R script file
script.close()
}
}
\references{
Ushey, K., Allaire, J., Wickham, H., & Ritchie, G. (2022). rstudioapi: Safely
access the RStudio API. R package version 0.14.
https://CRAN.R-project.org/package=rstudioapi
}
\seealso{
\code{\link{script.new}}, \code{\link{script.open}}, \code{\link{script.save}},
\code{\link{setsource}},
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
