% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z.test.R
\name{z.test}
\alias{z.test}
\alias{z.test.default}
\alias{z.test.formula}
\title{z-Test}
\usage{
z.test(x, ...)

\method{z.test}{default}(x, y = NULL, sigma = NULL, sigma2 = NULL, mu = 0, paired = FALSE,
       alternative = c("two.sided", "less", "greater"), conf.level = 0.95,
       digits = 2, p.digits = 3, as.na = NULL, check = TRUE,
       output = TRUE, \dots)

\method{z.test}{formula}(formula, data, as.na = NULL, check = TRUE, output = TRUE, \dots)
}
\arguments{
\item{x}{a numeric vector of data values.}

\item{y}{a numeric vector of data values.}

\item{sigma}{a numeric vector indicating the population standard deviation(s). In case
of two sample z-test, equal standard deviations are assumed when specifying one value
for the argument \code{sigma}; when specifying two values for the argument \code{sigma},
unequal standard deviations are assumed. Note that either argument \code{sigma} or
argument \code{sigma2} is specified.}

\item{sigma2}{a numeric vector indicating the population variance(s). In case of two sample z-test,
equal variances are assumed when specifying one value for the argument \code{sigma2};
when specifying two values for the argument \code{sigma}, unequal variance are assumed.
Note that either argument \code{sigma} or argument \code{sigma2} is specified.}

\item{mu}{a numeric value indicating the population mean under the null hypothesis. Note that
the argument \code{mu} is only used when computing a one sample z-test.}

\item{paired}{logical: if \code{TRUE}, paired sample z-test is computed.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of
\code{"two.sided"} (default), \code{"greater"} or \code{"less"}.}

\item{conf.level}{a numeric value between 0 and 1 indicating the confidence level of the interval.}

\item{digits}{an integer value indicating the number of decimal places to be used for displaying
descriptive statistics and confidence interval.}

\item{p.digits}{an integer value indicating the number of decimal places to be used for displaying
the \emph{p}-value.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting the analysis.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{output}{logical: if \code{TRUE}, output is shown on the console.}

\item{formula}{in case of two sample z-test (i.e., \code{paired = FALSE}), a formula of the
form \code{y ~ group} where \code{group} is a numeric variable, character variable
or factor with two values or factor levels giving the corresponding groups.}

\item{data}{a matrix or data frame containing the variables in the formula \code{formula}.}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following entries:
function call (\code{call}), type of analysis \code{type}, list with the input specified in \code{x}
(\code{data}), specification of function arguments (\code{args}), and result table (\code{result}).
}
\description{
This function computes one sample, two sample, and paired sample z-test.
}
\examples{
dat.bs <- data.frame(group = c(1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2),
                    x = c(3, 1, 4, 2, 5, 3, 2, 3, 6, 4, 3, NA))

#--------------------------------------
# Between-Subject Design

# Two-sided one sample z-test with 95\% confidence interval
# population mean = 3, population standard deviation = 1.2
z.test(dat.bs$x, sigma = 1.2, mu = 3)

# Two-sided one sample z-test with 95\% confidence interval
# population mean = 3, population variance = 1.44
z.test(dat.bs$x, sigma2 = 1.44, mu = 3)

# One-sided one sample z-test with 95\% confidence interval
# population mean = 3, population standard deviation = 1.2
z.test(dat.bs$x, sigma = 1.2, mu = 3, alternative = "greater")

# Two-sided one sample z-test with 95\% confidence interval
# population mean = 3, population standard deviation = 1.2
# # convert value 3 to NA
z.test(dat.bs$x, sigma = 1.2, mu = 3, as.na = 3)

# Two-sided one sample z-test with 99\% confidence interval
# population mean = 3, population standard deviation = 1.2
z.test(dat.bs$x, sigma = 1.2, mu = 3, conf.level = 0.99)

# Two-sided one sample z-test with 95\% confidence interval
# population mean = 3, population standard deviation = 1.2
# print descriptive statistics with 3 digits and p-value with 5 digits
z.test(dat.bs$x, sigma = 1.2, mu = 3, digits = 3, p.digits = 5)

# Two-sided two sample z-test with 95\% confidence interval
# population standard deviation (SD) = 1.2, equal SD assumption
z.test(x ~ group, sigma = 1.2, data = dat.bs)

# Two-sided two sample z-test with 95\% confidence interval
# population standard deviation = 1.2 and 1.5
z.test(x ~ group, sigma = c(1.2, 1.5), data = dat.bs)

# Two-sided two sample z-test with 95\% confidence interval
# population variance = 1.44 and 2.25
z.test(x ~ group, sigma = c(1.44, 2.25), data = dat.bs)

# One-sided two sample z-test with 95\% confidence interval
# population standard deviation (SD) = 1.2, equal SD assumption
z.test(x ~ group, sigma = 1.2, data = dat.bs, alternative = "less")

#-----------------

group1 <- c(3, 1, 4, 2, 5, 3, 6, 7)
group2 <- c(5, 2, 4, 3, 1)

# Two-sided two sample z-test with 95\% confidence interval
# population standard deviation (SD) = 1.2, equal SD assumption
z.test(group1, group2, sigma = 1.2, data = dat.bs)

#--------------------------------------
# Within-Subject Design
dat.ws <- data.frame(pre = c(1, 3, 2, 5, 7),
                     post = c(2, 2, 1, 6, 8), stringsAsFactors = FALSE)

# Two-sided paired sample z-test with 95\% confidence interval
# population standard deviation of difference score = 1.2
z.test(dat.ws$pre, dat.ws$post, sigma = 1.2, paired = TRUE)

# Two-sided paired sample z-test with 95\% confidence interval
# population variance of difference score = 1.44
z.test(dat.ws$pre, dat.ws$post, sigma2 = 1.44, paired = TRUE)

# One-sided paired sample z-test with 95\% confidence interval
# population standard deviation of difference score = 1.2
}
\references{
Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
John Wiley & Sons.
}
\seealso{
\code{\link{t.test}}, \code{\link{ci.mean.diff}}, \code{\link{ci.mean}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
