% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levenes.test.R
\name{levenes.test}
\alias{levenes.test}
\title{Levene's Test for Homogeneity of Variance}
\usage{
levenes.test(formula, data, method = c("median", "mean"), digits = 2, p.digits = 4,
             as.na = NULL, check = TRUE, output = TRUE)
}
\arguments{
\item{formula}{a formula of the form \code{y ~ group} where \code{y} is a numeric variable giving the
data values and \code{group} a numeric variable, character variable or factor with two ore more than two values or factor levels giving the corresponding groups.}

\item{data}{a matrix or data frame containing the variables in the formula \code{formula}.}

\item{method}{a character string specifying the method to compute the center of each group, i.e.
\code{method = "median"} (default) to compute the Levene's test basd on the median
(aka Brown-Forsythe test) or \code{method = "mean"} to compute the Levene's test
based on the arithmetic mean.}

\item{digits}{an integer value indicating the number of decimal places to be used for displaying results.}

\item{p.digits}{an integer value indicating the number of decimal places to be used for displaying the
\emph{p}-value.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting the analysis.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{output}{logical: if \code{TRUE}, output is shown.}
}
\value{
Returns an object of class \code{test}, which is a list with following entries:
function call (\code{call}), formula (\code{formula}), data frame with the outcome and grouping variable,
\code{data}, specification of function arguments (\code{args}), and object of class \code{"anova"}
(\code{result}).
}
\description{
This function computes Levene's test for homogeneity of variance across two or more independent groups.
}
\details{
Levene's test is equivalent to a one-way analysis of variance (ANOVA) with the absolute deviations
of observations from the mean of each group as dependent variable (\code{center = "mean"}). Brown
and Forsythe (1974) modified the Levene's test by using the absolute deviations of observations
from the median (\code{center = "median"}). By default, the Levene's test by using the absolute
deviations of observations from the median is computed.
}
\examples{
dat <- data.frame(y = c(2, 1, 4, 5, 3, 7, 8, 4, 1),
                  group = c(1, 1, 1, 2, 2, 2, 3, 3, 3))

# Levene's test based on the median
levenes.test(y ~ group, data = dat)

# Levene's test based on the arithmetic mean
levenes.test(y ~ group, data = dat, method = "mean")
}
\references{
Brown, M. B., & Forsythe, A. B. (1974). Robust tests for the equality of variances. \emph{Journal of the American
Statistical Association, 69}, 364-367.

Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
John Wiley & Sons.
}
\seealso{
\code{\link{t.test}}, \code{\link{aov}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
