% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.cont.coef.R
\name{print.cont.coef}
\alias{print.cont.coef}
\title{Print cont.coef object}
\usage{
\method{print}{cont.coef}(x, tri = x$args$tri, digits = x$args$digits,
      check = TRUE, ...)
}
\arguments{
\item{x}{\code{cont.coef} object.}

\item{tri}{a character string or character vector indicating which triangular of the matrix
to show on the console, i.e., \code{both} for upper and lower triangular,
\code{lower} for the lower triangular, and \code{upper} for the upper
triangular.}

\item{digits}{an integer value indicating the number of decimal places digits to be used for
displaying contingency coefficients.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function prints the \code{cont.coef} object
}
\examples{
dat <- data.frame(x = c(1, 1, 2, 1, 3, 3, 2, 2, 1, 2),
                  y = c(3, 2, 3, 1, 2, 4, 1, 2, 3, 4),
                  z = c(2, 2, 2, 1, 2, 2, 1, 2, 1, 2))

# Adjusted Contingency coefficient between x and y
dat.cont1 <- cont.coef(dat[, c("x", "y")], output = FALSE)

# Print cont.coef object with 5 digits
print(dat.cont1, digits = 5)
}
\seealso{
\code{\link{cont.coef}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
