% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_1_to_x.R
\name{delete_MNAR_1_to_x}
\alias{delete_MNAR_1_to_x}
\title{Create MNAR values using MNAR1:x}
\usage{
delete_MNAR_1_to_x(
  ds,
  p,
  miss_cols,
  x,
  cutoff_fun = median,
  prop = 0.5,
  use_lpSolve = TRUE,
  ordered_as_unordered = FALSE,
  stochastic = FALSE,
  add_realized_x = FALSE,
  ...
)
}
\arguments{
\item{ds}{a data frame or matrix in which missing values will be created}

\item{p}{a numeric vector with length one or equal to length \code{miss_cols};
the probability that a value is missing}

\item{miss_cols}{a vector of column names or indices of columns in which
missing values will be created}

\item{x}{numeric with length one (0 < x < \code{Inf}); odds are 1 to x for
the probability of a value to be missing in group 1 against the probability
of a value to be missing  in group 2 (see details)}

\item{cutoff_fun}{function that calculates the cutoff values in the
\code{ctrl_cols}}

\item{prop}{numeric of length one; (minimum) proportion of rows in group 1}

\item{use_lpSolve}{logical; should lpSolve be used for the determination of
groups, if \code{ctrl_cols[i]} is an unordered factor}

\item{ordered_as_unordered}{logical; should ordered factors be treated as
unordered factors}

\item{stochastic}{logical; see details}

\item{add_realized_x}{logical; if TRUE the realized odds for miss_cols will
be returned (as attribute)}

\item{...}{further arguments passed to \code{cutoff_fun}}
}
\value{
An object of the same class as \code{ds} with missing values
}
\description{
Create missing not at random (MNAR) values using MNAR1:x in a data frame or
a matrix
}
\details{
The functions \code{delete_MNAR_1_to_x} and \code{\link{delete_MAR_1_to_x}} are sisters. The only difference between these two functions is the column that controls the generation of missing values. In \code{\link{delete_MAR_1_to_x}} a separate column \code{ctrl_cols[i]} controls the generation of missing values in \code{miss_cols[i]}. In contrast, in \code{delete_MNAR_1_to_x} the generation of missing values in \code{miss_cols[i]} is controlled by \code{miss_cols[i]} itself. All other aspects are identical for both functions. Therefore, further details can be found in \code{\link{delete_MAR_1_to_x}}.
}
\examples{
ds <- data.frame(X = 1:20, Y = 101:120)
delete_MNAR_1_to_x(ds, 0.2, "X", x = 3)
}
\references{
Santos, M. S., Pereira, R. C., Costa, A. F., Soares, J. P.,
  Santos, J., & Abreu, P. H. (2019). Generating Synthetic Missing Data: A
  Review by Missing Mechanism. \emph{IEEE Access}, 7, 11651-11667
}
\seealso{
\code{\link{delete_MAR_1_to_x}}

Other functions to create MNAR: 
\code{\link{delete_MNAR_censoring}()},
\code{\link{delete_MNAR_one_group}()},
\code{\link{delete_MNAR_rank}()}
}
\concept{functions to create MNAR}
