% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirtsvd.R
\name{mirtsvd}
\alias{mirtsvd}
\title{Item Factor Analysis by Singular Value Decomposition}
\usage{
mirtsvd(data, K, link = "logit", epsilon = 1e-04, rotation_fn = NULL, ...)
}
\arguments{
\item{data}{the data matrix. Entries are either binary or categorical.
Missing entries should be \code{NA}.}

\item{K}{the number of factors.}

\item{link}{the link fucntion. Possible choices are "logit" and "probit".}

\item{epsilon}{the truncation parameter. Default value is 1e-4.}

\item{rotation_fn}{rotation applied to the estimated loading matrix.
See \code{\link{rotations}}.
If \code{NULL}, no rotation would be applied.}

\item{...}{optional arguments passed to rotation_fn.}
}
\value{
The function returns a list with the following components:
\describe{
\item{loadings}{The estimated loading matrix.}
\item{rotation}{The rotation method.}
\item{type}{The data type.}
\item{number}{The number of categories in data.}
}
}
\description{
Item Factor Analysis by Singular Value Decomposition
}
\examples{
require(mirtjml)
require(GPArotation)

# load a simulated dataset
attach(data_sim)

data <- data_sim$response
K <- data_sim$K
res <- mirtsvd(data, K, rotation_fn = Varimax)

}
\references{
Zhang, H., Chen, Y., & Li, X. (2020). A note on exploratory item factor
analysis by singular value decomposition. Psychometrika, 1-15, \doi{10.1007/s11336-020-09704-7}.
}
