% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.LR.R
\name{boot.LR}
\alias{boot.LR}
\title{Parametric bootstrap likelihood-ratio test}
\usage{
boot.LR(mod, mod2, R = 1000, verbose = TRUE)
}
\arguments{
\item{mod}{an estimated model object, more constrained than \code{mod2}}

\item{mod2}{an estimated model object}

\item{R}{number of parametric bootstraps to use.}

\item{verbose}{logical; include additional information in the console?}
}
\value{
a p-value evaluating whether the more restrictive model fits significantly worse
  than the less restrictive model
}
\description{
Given two fitted models, compute a parametric bootstrap test to determine whether
the less restrictive models fits significantly better than the more restricted model.
Note that this hypothesis test also works when prior parameter distributions are included for
either model. Function can be run in parallel after using a suitable \code{\link{mirtCluster}}
definition.
}
\examples{

\dontrun{

#standard
dat <- expand.table(LSAT7)
mod1 <- mirt(dat, 1)
mod2 <- mirt(dat, 1, '3PL')

# standard LR test
anova(mod1, mod2)

# bootstrap LR test (run in parallel to save time)
mirtCluster()
boot.LR(mod1, mod2, R=200)

}
}
\references{
Chalmers, R., P. (2012). mirt: A Multidimensional Item Response Theory
Package for the R Environment. \emph{Journal of Statistical Software, 48}(6), 1-29.
\doi{10.18637/jss.v048.i06}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{bootstrap}
\keyword{parametric}
