% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipe.R
\name{\%>>\%}
\alias{\%>>\%}
\alias{.}
\title{Deferred Evaluation Pipe}
\usage{
x \%>>\% f

.(expr)
}
\arguments{
\item{x}{a 'mirai' or mirai value at \code{$data} that is possibly an
'unresolvedValue'.}

\item{f}{a function that accepts 'x' as its first argument.}

\item{expr}{a piped expression.}
}
\value{
The evaluated result, or if the mirai value of x is an
    'unresolvedValue', an 'unresolvedExpr'.

    It is advisable to wrap \code{resolve()} around a piped expression to
    ensure stability of return types, as this is guaranteed to return either
    an 'unresolvedExpr' or 'resolvedExpr'.
}
\description{
Pipe a possibly unresolved value forward into a function. The piped expression
    should be wrapped in \code{.()}.
}
\details{
An 'unresolvedExpr' encapsulates the eventual evaluation result.
    Query its \code{$data} element for resolution. Once resolved, the object
    changes into a 'resolvedExpr' and the evaluated result will be available
    at \code{$data}.

    Supports stringing together a series of piped expressions (as per
    the below example).

    Wrap a piped expression in \code{.()} to ensure that the return value is
    always an 'unresolvedExpr' or 'resolvedExpr' as the case may be,
    otherwise if 'x' is already resolved, the evaluated result would be
    returned directly.

    \code{\link{unresolved}} may be used on an expression or its \code{$data}
    element to test for resolution.
}
\section{Usage}{


    Usage is similar to R's native \code{|>} pipe.

    \code{x \%>>\% f} is equivalent to \code{f(x)}

    \code{x \%>>\% f()} is equivalent to \code{f(x)}

    \code{x \%>>\% f(y)} is equivalent to \code{f(x, y)}

    Please note that other usage is not supported and it is not a drop-in
    replacement for magrittr's \code{\%>\%} pipe.
}

\examples{
if (interactive()) {
# Only run examples in interactive R sessions

m <- mirai({Sys.sleep(0.5); 1})
b <- .(m \%>>\% c(2, 3) \%>>\% as.character)
unresolved(b)
b
b$data

call_mirai(m)
unresolved(b)
b
b$data

}

}
