% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{everywhere}
\alias{everywhere}
\title{Evaluate Everywhere}
\usage{
everywhere(.expr, ..., .args = list(), .compute = "default")
}
\arguments{
\item{.expr}{an expression to evaluate asynchronously (of arbitrary length,
wrapped in \{ \} where necessary), \strong{or} a language object passed
by \link{name}.}

\item{...}{(optional) named arguments (name = value pairs) specifying
objects referenced in '.expr'. Used in addition to, and taking precedence
over, any arguments specified via '.args'.}

\item{.args}{(optional) \strong{either} a list of objects to be passed by
\link{name} (found in the current scope), \strong{or else} a list of
name = value pairs, as in '...'. If an object other than a list is
supplied, it will be coerced to a list.}

\item{.compute}{[default 'default'] character value for the compute profile
to use (each compute profile has its own set of daemons for connecting to
different resources).}
}
\value{
Invisible NULL.
}
\description{
Evaluate an expression 'everywhere' on all connected daemons for the
    specified compute profile. Designed for performing setup operations
    across daemons or exporting common data, resultant changes to the global
    environment, loaded packages or options are persisted regardless of a
    daemon's 'cleanup' setting.
}
\examples{
if (interactive()) {
# Only run examples in interactive R sessions

daemons(1)
# export common data by super-assignment:
everywhere(y <<- 3)
# assign explicitly to global environment:
everywhere(list2env(x, envir = .GlobalEnv), x = list(a = 1, b = 2))
m <- mirai(a + b - y == 0L)
call_mirai(m)$data
daemons(0)

daemons(1, dispatcher = FALSE)
everywhere(library(parallel))
m <- mirai("package:parallel" \%in\% search())
call_mirai(m)$data
daemons(0)

}

}
