% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispatcher.R
\name{saisei}
\alias{saisei}
\title{Saisei (Regenerate Token)}
\usage{
saisei(i, force = FALSE, .compute = "default")
}
\arguments{
\item{i}{integer index number URL to regenerate at dispatcher.}

\item{force}{[default FALSE] logical value whether to regenerate the URL even
when there is an existing active connection.}

\item{.compute}{[default 'default'] character compute profile (each compute
profile has its own set of daemons for connecting to different resources).}
}
\value{
The regenerated character URL upon success, or else NULL.
}
\description{
When using daemons with dispatcher, regenerates the token for the URL a
    dispatcher socket listens at.
}
\details{
When a URL is regenerated, the listener at the specified socket is
    closed and replaced immediately, hence this function will only be
    successful if there are no existing connections at the socket (i.e.
    'online' status shows 0), unless the argument 'force' is specified as TRUE.

    If 'force' is specified as TRUE, the socket is immediately closed and
    regenerated. If this happens while a mirai is still ongoing, it will be
    returned as an errorValue 7 'Object closed'. This may be used to cancel a
    task that consistently hangs or crashes to prevent it from failing
    repeatedly when new daemons connect.
}
\examples{
if (interactive()) {
# Only run examples in interactive R sessions

daemons(1L)
Sys.sleep(1L)
status()
saisei(i = 1L, force = TRUE)
status()

daemons(0)

}

}
