% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mine_compute_pstats}
\alias{mine_compute_pstats}
\title{Compute pairwise statistics (MIC and normalized TIC) between variables
(convenience function).}
\usage{
mine_compute_pstats(x, alpha = 0.6, C = 15, est = "mic_approx")
}
\arguments{
\item{x}{Numeric matrix of m-by-n of n variables and m samples}

\item{alpha}{alpha parameter for the mine statistic}

\item{C}{c parameter for the mine statistic}

\item{est}{estimation parameter for the mine statistic}
}
\value{
Matrix (n x (n-1)/2) by 4. The first and second column indicate the indexes relative of the columns 
in the inut matrix the statistic is computed for.
Column 3 contains the MIC statistic, while column 4 contains the normalized TIC statistic.
}
\description{
For each statistic, the upper triangle of the matrix is stored by row
(condensed matrix). If m is the number of variables, then for i < j < m, the
statistic between (col) i and j is stored in k = m*i - i*(i+1)/2 - i - 1 + j.
The length of the vectors is n = m*(m-1)/2.
}
