#' Three-mode American power elite database
#'
#' This data is based on 26 elites who sat on the boards of directors 
#' for at least two of six economic policy making organizations (Domhoff 2016),
#' and also made campaign contributions to one or more of six candidates 
#' running in the primary election contests for the 2008 Presidential nominations 
#' of the Republican Party (Rudy Giuliani, John McCain, Mitt Romney) 
#' or the Democratic Party (Hillary Clinton, Christopher Dodd, Barack Obama).
#'
#' @docType data
#' @keywords datasets
#' @name mpn_elite_usa_money
#' @usage data(mpn_elite_usa_money)
#' @format Matrix with 26 rows and 6+6 columns
#' @references 
#' Domhoff, G William. 2016. \href{https://whorulesamerica.ucsc.edu/power_elite/}{“Who Rules America? Power Elite Database.”}
#' 
#' The Center for Responsive Politics. 2019. \href{http://www.opensecrets.org}{“OpenSecrets.”}
#' 
#' Knoke, David, Mario Diani, James Hollway, and Dimitris C Christopoulos. 2021. 
#' \href{https://www.cambridge.org/core/books/multimodal-political-networks/43EE8C192A1B0DCD65B4D9B9A7842128}{\emph{Multimodal Political Networks}}. 
#' Cambridge University Press. Cambridge University Press.
"mpn_elite_usa_money"
