% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum_region.R
\name{sum_region}
\alias{sum_region}
\alias{sum_country}
\title{Summary of regional in-, out-, turnover and net-migration totals from an origin-destination migration flow matrix or data frame.}
\usage{
sum_region(
  m,
  drop_diagonal = TRUE,
  orig_col = "orig",
  dest_col = "dest",
  flow_col = "flow",
  international = FALSE,
  include_net = TRUE
)

sum_country(
  m,
  drop_diagonal = TRUE,
  orig_col = "orig",
  dest_col = "dest",
  flow_col = "flow",
  include_net = TRUE,
  international = TRUE
)
}
\arguments{
\item{m}{A \code{matrix} or data frame of origin-destination flows. For \code{matrix} the first and second dimensions correspond to origin and destination respectively. For a data frame ensure the correct column names are passed to \code{orig_col}, \code{dest_col} and \code{flow_col}.}

\item{drop_diagonal}{Logical to indicate dropping of diagonal terms, where the origin and destination are the same, in the calculation of totals. Default \code{TRUE}.}

\item{orig_col}{Character string of the origin column name (when \code{m} is a data frame rather than a \code{matrix})}

\item{dest_col}{Character string of the destination column name (when \code{m} is a data frame rather than a \code{matrix})}

\item{flow_col}{Character string of the flow column name (when \code{m} is a data frame rather than a \code{matrix})}

\item{international}{Logical to indicate if flows are international.}

\item{include_net}{Logical to indicate inclusion of a net migration total column for each region, in addition to the total in- and out-flows. Default \code{TRUE}.}
}
\value{
A \code{tibble} with total in-, out- and turnover of flows for each region.
}
\description{
Summary of regional in-, out-, turnover and net-migration totals from an origin-destination migration flow matrix or data frame.
}
\examples{
# matrix
r <- LETTERS[1:4]
m <- matrix(data = c(0, 100, 30, 70, 50, 0, 45, 5, 60, 35, 0, 40, 20, 25, 20, 0),
            nrow = 4, ncol = 4, dimnames = list(orig = r, dest = r), byrow = TRUE)
m
sum_region(m)
  
\dontrun{
# data frame (tidy) format
library(tidyverse)

# download Abel and Cohen (2019) estimates
f <- read_csv("https://ndownloader.figshare.com/files/38016762", show_col_types = FALSE)
f

# single period
f \%>\% 
  filter(year0 == 1990) \%>\%
  sum_country(flow_col = "da_pb_closed")

# all periods using group_by
f \%>\% 
  group_by(year0) \%>\%
  sum_country(flow_col = "da_pb_closed")
}   
}
