% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block_matrix.R
\name{block_matrix}
\alias{block_matrix}
\title{Create a block matrix with non-uniform block sizes.}
\usage{
block_matrix(x = NULL, b = NULL, byrow = FALSE, dimnames = NULL)
}
\arguments{
\item{x}{Vector of numbers to identify each block.}

\item{b}{Numeric value for the size of the blocks within the matrix ordered depending on \code{byrow}}

\item{byrow}{Logical value. If \code{FALSE} (the default) the blocks are filled by columns, otherwise the blocks in the matrix are filled by rows.}

\item{dimnames}{Character string of name attribute for the basis of the block matrix. If \code{NULL} a vector of the same length of \code{b} provides the basis of row and column names.#'}
}
\value{
Returns a \code{matrix} with block sizes determined by the \code{b} argument. Each block is filled with the same value taken from \code{x}.
}
\description{
Creates a \code{matrix} with differing size blocks
}
\examples{
block_matrix(x = 1:16, b = c(2,3,4,2))

block_matrix(x = 1:25, b = c(2,3,4,2,1))
}
\seealso{
\code{\link{stripe_matrix}}
}
\author{
Guy J. Abel
}
