% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_pob_tot.R
\name{match_pob_tot}
\alias{match_pob_tot}
\title{Adjust Migrant Stock Tables to Have Matching Place of Birth Totals}
\usage{
match_pob_tot(m1, m2, method = "rescale")
}
\arguments{
\item{m1}{Matrix of migrant stock totals at time \emph{t}. Rows in the matrix correspond to place of birth and columns to place of residence at time \emph{t}+1.}

\item{m2}{Matrix of migrant stock totals at time \emph{t}+1. Rows in the matrix correspond to place of birth and columns to place of residence at time \emph{t}+1.}

\item{method}{Character string matching either \code{rescale}, \code{open}, \code{open-dr}. The \code{rescale} method ensure flow estimates closely match the net migration totals implied by the changes in population totals, births and deaths - as introduced in the Science paper. The \code{open-dr} method allows for moves in and out of the global system - as introduced in the Demographic Research paper. The \code{open} method is a slight improvement over \code{open-dr} - the calculation of the moves and in and out use more sensible weights.}
}
\value{
Returns a \code{list} object with:
\item{m1_adj }{Matrix of adjusted \code{m1} where rows (place of births) match \code{m2_adj}.}
\item{m2_adj }{Matrix of adjusted \code{m2} where rows (place of births) match \code{m1_adj}.}
\item{in_mat }{Matrix of estimated inflows into the system.}
\item{out_mat }{Matrix of estimated outflows from the system.}
}
\description{
This function is predominantly intended to be used within the ffs routines in the migest package.
}
\references{
Abel, G. J. (2018). Estimates of Global Bilateral Migration Flows by Gender between 1960 and 2015. \emph{International Migration Review} Forthcoming.

Abel, G. J. and Sander, N. (2014). Quantifying Global International Migration Flows. \emph{Science}, 343 (6178) 1520-1522
}
\seealso{
\code{\link{ipf3_qi}}, \code{\link{ffs_diff}}
}
\author{
Guy J. Abel
}
