% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipf2.R
\name{ipf2}
\alias{ipf2}
\title{Iterative Proportional Fitting Routine for the Indirect Estimation of Origin-Destination Migration Flow Table with Known Margins.}
\usage{
ipf2(rtot = NULL, ctot = NULL, m = matrix(1, length(rtot), length(ctot)),
  tol = 1e-05, maxit = 500, verbose = FALSE)
}
\arguments{
\item{rtot}{Vector of origin totals to constrain the sum of the imputed cell rows.}

\item{ctot}{Vector of destination totals to constrain the sum of the imputed cell columns.}

\item{m}{Matrix of auxiliary data. By default set to 1 for all origin-destination combinations.}

\item{tol}{Numeric value for the tolerance level used in the parameter estimation.}

\item{maxit}{Numeric value for the maximum number of iterations used in the parameter estimation.}

\item{verbose}{Logical value to indicate the print the parameter estimates at each iteration. By default \code{FALSE}.}
}
\value{
Iterative Proportional Fitting routine set up in a similar manner to Agresti (2002, p.343). This is equivalent to a conditional maximization of the likelihood, as discussed by Willekens (1999), and hence provides identical indirect estimates to those obtained from the \code{\link{cm2}} routine. 

The user must ensure that the row and column totals are equal in sum. Care must also be taken to allow the dimension of the auxiliary matrix (\code{m}) to equal those provided in the row and column totals.

If only one of the margins is known, the function can still be run. The indirect estimates will correspond to the log-linear model without the \eqn{\alpha_{i}} term if (\code{rtot = NULL}) or without the \eqn{\beta_{j}} term if (\code{ctot = NULL})

Returns a \code{list} object with
\item{mu }{Origin-Destination matrix of indirect estimates}
\item{it }{Iteration count}
\item{tol }{Tolerance level at final iteration}
}
\description{
The \code{ipf2} function finds the maximum likelihood estimates for fitted values in the log-linear model:
\deqn{\log y_{ij} = \log \alpha_{i} + \log \beta_{j} + \log m_{ij} }
where \eqn{m_{ij}} is a set of prior estimates for \eqn{y_{ij}} and itself is no more complex than the one being fitted.
}
\examples{
## with Willekens (1999) data
dn <- LETTERS[1:2]
y <- ipf2(rtot = c(18, 20), ctot = c(16, 22), 
          m = matrix(c(5, 1, 2, 7), ncol = 2, 
                     dimnames = list(orig = dn, dest = dn)))
round(addmargins(y$mu),2)

## with all elements of offset equal
y <- ipf2(rtot = c(18, 20), ctot = c(16, 22))
round(addmargins(y$mu),2)

## with bigger matrix
dn <- LETTERS[1:3]
y <- ipf2(rtot = c(170, 120, 410), ctot = c(500, 140, 60), 
          m = matrix(c(50, 10, 220, 120, 120, 30, 545, 0, 10), ncol = 3, 
                     dimnames = list(orig = dn, dest = dn)))
# display with row and col totals
round(addmargins(y$mu))

## only one margin known
dn <- LETTERS[1:2]
y <- ipf2(rtot = c(18, 20), ctot = NULL, 
          m = matrix(c(5, 1, 2, 7), ncol = 2, 
                     dimnames = list(orig = dn, dest = dn)))
round(addmargins(y$mu))
}
\references{
Agresti, A. (2002). \emph{Categorical Data Analysis} 2nd edition. Wiley. 

Willekens, F. (1999). Modelling Approaches to the Indirect Estimation of Migration Flows: From Entropy to EM. \emph{Mathematical Population Studies} 7 (3), 239--78.
}
\seealso{
\code{\link{cm2}}, \code{\link{ipf3}}
}
\author{
Guy J. Abel
}
