% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmid_mid_breakdown.R
\name{ggmid.mid.breakdown}
\alias{ggmid.mid.breakdown}
\alias{autoplot.mid.breakdown}
\title{Plot MID Breakdown with ggplot2 Package}
\usage{
\method{ggmid}{mid.breakdown}(
  object,
  type = c("waterfall", "barplot", "dotchart"),
  theme = NULL,
  terms = NULL,
  max.bars = 15L,
  width = NULL,
  vline = TRUE,
  catchall = "others",
  format = c("\%t=\%v", "\%t"),
  ...
)

\method{autoplot}{mid.breakdown}(object, ...)
}
\arguments{
\item{object}{a "mid.breakdown" object to be visualized.}

\item{type}{a character string specifying the type of the plot. One of "waterfall", "barplot" or "dotchart".}

\item{theme}{a character string specifying the color theme or any item that can be used to define "color.theme" object.}

\item{terms}{an optional character vector specifying the terms to be displayed.}

\item{max.bars}{an integer specifying the maximum number of bars in the plot.}

\item{width}{a numeric value specifying the width of the bars.}

\item{vline}{logical. If \code{TRUE}, the vertical line is drawn at zero or the intercept.}

\item{catchall}{a character string to be used as the catchall label.}

\item{format}{a character string or character vector of length two to be used as the format of the axis labels. "t" and "v" immediately after the percent sign are replaced with the corresponding term and value.}

\item{...}{optional parameters to be passed to the main layer.}
}
\value{
\code{ggmid.mid.breakdown()} returns a "ggplot" object.
}
\description{
For "mid.breakdown" objects, \code{ggmid()} visualizes the breakdown of a prediction by component functions.
}
\details{
The S3 method of \code{ggmid()} for "mid.breakdown" objects creates a "ggplot" object that visualizes the breakdown of a single model prediction.
The main layer is drawn using \code{geom_col()}.
}
\examples{
data(diamonds, package = "ggplot2")
set.seed(42)
idx <- sample(nrow(diamonds), 1e4)
mid <- interpret(price ~ (carat + cut + color + clarity)^2, diamonds[idx, ])
mbd <- mid.breakdown(mid, diamonds[1L, ])
ggmid(mbd, type = "waterfall")
ggmid(mbd, type = "waterfall", theme = "midr")
ggmid(mbd, type = "barplot", theme = "Set 1")
ggmid(mbd, type = "dotchart", size = 3, theme = "Cividis")
}
