% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primers.R
\name{iupac2regex}
\alias{iupac2regex}
\alias{regex2iupac}
\alias{uipac2regex}
\title{Ambiguity symbol conversion}
\usage{
iupac2regex( s )
regex2iupac( s )
}
\arguments{
\item{s}{Character string containing a DNA sequence.}
}
\value{
A string where the ambiguity symbol has been replaced by a regular expression
(\code{iupac2regex}) or a regular expression has been replaced by an ambiguity symbol
(\code{regex2iupac}).
}
\description{
Converting DNA ambiguity symbols to regular expressions, and vice versa.
}
\details{
The DNA alphabet may contain ambiguity symbols, e.g. a W means either A or T.
When using a regular expression search, these letters must be replaced by the proper
regular expression, e.g. W is replaced by [AT] in the string. These function makes this
translations
}
\examples{
iupac2regex( "ACWGT" )
regex2iupac( "AC[AG]GT" )

}
\author{
Lars Snipen.
}

