% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaaGenerics.R, R/fastRankSchemes.R,
%   R/rankScheme.R, R/rankTimePoints.R
\docType{methods}
\name{rankObject}
\alias{rankObject}
\alias{fastRankSchemes}
\alias{rankObject,SetOfSchemes-method}
\alias{rankObject,SetOfTimePoints-method}
\title{generic function to calulate a \code{ranking}-slot}
\usage{
rankObject(object, ...)

fastRankSchemes(object, pkData, objective, nCores = 1)

\S4method{rankObject}{SetOfSchemes}(object, pkData, objective,
  varianceMeasure = "var", scaleWith = "max", skipTests = FALSE,
  nCores = 1)

\S4method{rankObject}{SetOfTimePoints}(object, pkData, nGrid = 100,
  nSamplesAvCurve = 1000, useAverageRat = FALSE, avCurve = NULL,
  nCores = 1)
}
\arguments{
\item{object}{a S4 class object}

\item{...}{additional parameters}

\item{pkData}{\code{\link{PkData-class}}}

\item{objective}{a \code{data.frame} with columns:
\itemize{
  \item{criterion}{ summary function of an estimeted pkCurve (data frame with columns time and concentration):  area under the curve (\code{auc}) ; maximum concentration 
     (\code{cMax}) and time when the maximum concentration is reached (\code{tMax}); 
      user defined functions are alowed but prefix \code{pkCurveStat_} should be added in function definition, see examples \code{\link{pkCurveStat}} 
   }
   \item{weight}{ relative importance of the different criteria}
}}

\item{nCores}{number of cores used in parellel processing, defaults to 1}

\item{varianceMeasure}{variance criteria applied to the objective, defaults to summarise objective over sample data, defaults to  \code{var}}

\item{scaleWith}{function to scale different criteria in \code{objective} before combining results by taking a weighted sum}

\item{skipTests}{if \code{TRUE} object validity and compatibility is not tested, defaults to \code{FALSE} , doing these tests is slow}

\item{nGrid}{number of equally spaced point to calculate the distance between sample and population averaged kinetic curve, defaults to 100}

\item{nSamplesAvCurve}{the number of samples to calculate the averaged curve ( only to rank \code{\link{SetOfTimePoints-class}}),
defaults to 1000}

\item{useAverageRat}{logical value if TRUE, the average rat (with random effects equal to zero and no additional error) is used instead of the integrated out population averaged curve, 
defaults to FALSE; this is faster but biased}

\item{avCurve}{a user specified averaged curve, when specified, the average curve is no longer calculated from the pkModel, defaults to \code{NULL}}
}
\value{
\code{\link{SetOfSchemes-class}} object
}
\description{
generic function to calulate a \code{ranking}-slot
}
\details{
\code{fastRankSchemes} is a faster version to rank\code{\link{SetOfSchemes-class}} objects ,
  with fixed settings ( objective AUC and cMax , summary measure is variance and scale measure is maximum ). It is meant to be used 
inside the shiny application
}
\note{
when ranking \code{\link{SetOfSchemes-class}} using if multiple criteria, the combined criterion is rescaled such that the best result is 1

if \code{\link{SetOfTimePoints-class}} timePoints are ranked according to mimimal distance between population average curve and 
the estimate of the population average curve based on a selection of time points.
}
\examples{
\dontrun{
  setOfSchemes             <-  getExampleSetOfSchemes()
  dataForSchemes            <-  getExampleData()
  ex1       <-  rankObject( object = setOfSchemes, dataForSchemes ,
    objective = data.frame( criterion = "auc" , weight = 1 ) )
  getRanking(ex1) # to get the dataframe and not the whole object
  ex2       <-  rankObject( object = setOfSchemes, dataForSchemes ,
    objective = data.frame( criterion = "auc" , weight = 1 )  ,
    varianceMeasure = "sd" , scaleWith = "min" ) 
  getRanking(ex2) 
  ex3       <-  rankObject( object = setOfSchemes, dataForSchemes ,
    objective = data.frame( criterion = c( "auc" , "cMax" , "tMax" )  ,
     weight = c( 9 , 1, 1 ) ) ) 
  getRanking(ex3)

  # example with own defined varianceMeasure
  rangeWidth     <-  function( x ){
     range <-  range(x) ;
     rangeWith  <-  range[2] - range[1]; rangeWith
   }
  ex4       <-  rankObject( object = setOfSchemes, dataForSchemes , 
      objective = data.frame( criterion = c( "auc" , "cMax" , "tMax" )  , 
      weight = c( 9 , 1, 1 ) ) ,
      varianceMeasure = "rangeWidth" ,
      scaleWith = "mean" ) 
}
\dontrun{
 fullTimePoints    <-  0:10
 setOfTimePoints   <-  getExampleSetOfTimePoints( fullTimePoints)
 pkDataExample     <-  getPkData( getExamplePkModel() , getTimePoints( setOfTimePoints ) , 
   nSubjectsPerScheme = 5 , nSamples = 17   )
 ex1               <-  rankObject( object = setOfTimePoints , pkData = pkDataExample ,
     nGrid = 75 , nSamplesAvCurve = 13)
 ex2               <-  rankObject( object = setOfTimePoints ,   pkData = pkDataExample , 
     nGrid = 75 , nSamplesAvCurve = 13 , useAverageRat = TRUE )
 ex3               <-  rankObject( object = setOfTimePoints ,   pkData = pkDataExample ,
     nGrid = 75 , avCurve = rep(0 , length(fullTimePoints) ) )
}
}
\keyword{export}
