% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.microbenchmark}
\alias{autoplot.microbenchmark}
\title{Autoplot method for microbenchmark objects: Prettier graphs for
microbenchmark using ggplot2}
\usage{
autoplot.microbenchmark(object, ..., log = TRUE, y_max = 1.05 *
  max(object$time))
}
\arguments{
\item{object}{A microbenchmark object}

\item{\dots}{Ignored}

\item{log}{If \code{TRUE} the time axis will be on log scale.}

\item{y_max}{The upper limit of the y axis (defaults to 5 percent more than
the maximum value)}
}
\value{
A ggplot2 plot
}
\description{
Uses ggplot2 to produce a more legible graph of microbenchmark timings
}
\examples{
if (requireNamespace("ggplot2")) {

tm <- microbenchmark(rchisq(100, 0),
                     rchisq(100, 1),
                     rchisq(100, 2),
                     rchisq(100, 3),
                     rchisq(100, 5), times=1000L)
ggplot2::autoplot(tm)
}
}
\author{
Ari Friedman, Olaf Mersmann
}
