% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micomp.R
\name{summary.micomp}
\alias{summary.micomp}
\title{Summary method for multiple comparisons of outputs}
\usage{
\method{summary}{micomp}(object, ...)
}
\arguments{
\item{object}{Object of class \code{\link{micomp}}.}

\item{...}{Currently ignored.}
}
\value{
A list in which each component is associated with a distinct
comparison. Each component contains a matrix, in which columns represent
individual outputs and rows have information about the outputs. More
specifically, each matrix has the following rows:
\describe{
 \item{#PCs (ve=\%)}{Number of principal components required to explain the
       specified percentage of variance. There is one row of this kind for
       each percentage of variance specified when creating the
       \code{\link{micomp}} object.}
 \item{MANOVA (ve=\%)}{\emph{P}-value for the MANOVA test applied to the #PCs
       required to explain the specified percentage of variance. There is one
       row of this kind for each percentage of variance specified when
       creating the \code{\link{micomp}} object.}
 \item{par.test}{\emph{P}-value for the parametric test (first principal
       component).}
 \item{nonpar.test}{\emph{P}-value for the non-parametric test (first
       principal component).}
 \item{par.test.adjust}{\emph{P}-value for the parametric test (first
       principal component), adjusted with the weighted Bonferroni procedure,
       percentage of explained variance used as weight.}
 \item{nonpar.test.adjust}{\emph{P}-value for the non-parametric test (first
       principal component), adjusted with the weighted Bonferroni procedure,
       percentage of explained variance used as weight.}
}
}
\description{
Summary method for objects of class \code{\link{micomp}}.
}
\examples{

# A micomp object from package datasets (i.e. grpoutputs objects) directly
\donttest{
summary(micomp(5, 0.85,
               list(list(name = "CompEq", grpout = pphpc_ok),
                    list(name = "CompNoShuf", grpout = pphpc_noshuff),
                    list(name = "CompDiff", grpout = pphpc_diff))))
}
}
