% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assumptions.R
\name{plot.assumptions_paruv}
\alias{plot.assumptions_paruv}
\title{Plot \emph{p}-values for testing the assumptions of the parametric tests used
in output comparison}
\usage{
\method{plot}{assumptions_paruv}(x, ...)
}
\arguments{
\item{x}{Objects of class \code{\link{assumptions_paruv}}.}

\item{...}{Extra options passed to \code{\link[graphics]{barplot}}. The
\code{col} parameter defines colors for \emph{p}-values below 1, 0.05 and
0.01, respectively.}
}
\value{
None.
}
\description{
Plot method for objects of class \code{\link{assumptions_paruv}} containing
\emph{p}-values produced by testing the assumptions of the parametric tests
used for comparing outputs.
}
\details{
One bar plot is presented for the Bartlett test
(\code{\link[stats]{bartlett.test}}), showing the respective \emph{p}-values
along principal component. \emph{s} bar plots are presented for the
Shapiro-Wilk (\code{\link[stats]{shapiro.test}}), where \emph{s} is the
number of groups being compared; individual bars in each plot represent the
\emph{p}-values associated with each principal component.
}
\examples{

# Plot the Shapiro-Wilk and Bartlett test p-values for each dependent
# variable of the iris data
plot(assumptions_paruv(iris[, 1:4], iris[, 5]))

# Plot the same data with logarithmic scale for p-values
plot(assumptions_paruv(iris[, 1:4], iris[, 5]), log = "y")

}

