% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{VIF}
\alias{VIF}
\title{\code{VIF} function for assessing VIF.}
\usage{
VIF(x, posit_y, posit_x)
}
\arguments{
\item{x}{a numeric matrix - a numeric matrix with variables}

\item{posit_y}{an integer - a position of dependent variable}

\item{posit_x}{an integer vector - positions of independent variables}
}
\value{
load a numeric vector with VIF for all variables provided by posit_x
}
\description{
VIF measure how much the variance of the estimated regression coefficients are inflated.
It helps to identify when the predictor variables are linearly related.
You have to decide which variable should be delete. Values higher than 10 signal a potential collinearity problem.
}
\examples{
\dontrun{
library(miceFast)
library(data.table)

airquality2 = airquality
airquality2$Temp2 = airquality2$Temp**2
#install.packages("car")
#car::vif(lm(Ozone ~ ., data=airquality2))


data_DT = data.table(airquality2)
# VIF for variables at 1,3,4 positions - you include a y position to consider its NA values
data_DT[,.(vifs=VIF(x=as.matrix(.SD),
                    posit_y=1,
                    posit_x=c(2,3,4,5,6,7)))]

######################
#OR using OOP miceFast
######################

airquality2_mat = as.matrix(airquality2)
model = new(miceFast)
model$set_data(airquality2_mat)

as.vector(model$vifs(1,c(2,3,4,5,6,7)))

}

}
\seealso{
\code{\link{fill_NA}} \code{\link{fill_NA_N}}
}
