% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estparmvggd.R
\name{estparmvggd}
\alias{estparmvggd}
\title{Estimation of the Parameters of a Multivariate Generalized Gaussian Distribution}
\usage{
estparmvggd(x, eps = 1e-6, display = FALSE, plot = display)
}
\arguments{
\item{x}{numeric matrix or data frame.}

\item{eps}{numeric. Precision for the estimation of the beta parameter.}

\item{display}{logical. When \code{TRUE} the value of the \code{beta} parameter at each iteration is printed.}

\item{plot}{logical. When \code{TRUE} the successive values of the \code{beta} parameter are plotted, allowing to visualise its convergence.}
}
\value{
A list of 3 elements:
\itemize{
\item \code{mu} the mean vector.
\item \code{Sigma}: symmetric positive-definite matrix. The dispersion matrix.
\item \code{beta} non-negative numeric value. The shape parameter.
}
with two attributes \code{attr(, "epsilon")} (precision of the result) and \code{attr(, "k")} (number of iterations).
}
\description{
Estimation of the mean vector, dispersion matrix and shape parameter of a multivariate generalized Gaussian distribution (MGGD).
}
\details{
The \eqn{\mu} parameter is the mean vector of \code{x}.

The dispersion matrix \eqn{\Sigma} and shape parameter: \eqn{\beta} are computed
using the method presented in Pascal et al., using an iterative algorithm.

The precision for the estimation of \code{beta} is given by the \code{eps} parameter.
}
\examples{
mu <- c(0, 1, 4)
Sigma <- matrix(c(0.8, 0.3, 0.2, 0.3, 0.2, 0.1, 0.2, 0.1, 0.2), nrow = 3)
beta <- 0.74
x <- mvrggd(100, mu, Sigma, beta)

# Estimation of the parameters
estparmvggd(x)

}
\references{
F. Pascal, L. Bombrun, J.Y. Tourneret, Y. Berthoumieu. Parameter Estimation For Multivariate Generalized Gaussian Distribution.
IEEE Trans. Signal Processing, vol. 61 no. 23, p. 5960-5971, Dec. 2013.
\doi{DOI: 10.1109/TSP.2013.2282909}
}
\seealso{
\code{\link{mvdggd}}: probability density of a MGGD.

\code{\link{mvrggd}}: random generation from a MGGD.
}
\author{
Pierre Santagostini, Nizar Bouhlel
}
