% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L_fitDens.R
\name{l_fitDens}
\alias{l_fitDens}
\title{Adding density strip of fitted effect}
\usage{
l_fitDens(n = 50, level = 0.95, trans = identity, ...)
}
\arguments{
\item{n}{sqrt of the number of grid points used to compute the effect plot.}

\item{level}{confidence level. By default the conditional density of the fit will be plotted
between the Gaussian quantiles 0.025 and 0.975, hence the \code{level} determines the
width of the y-axis.}

\item{trans}{monotonic function to be applied to the density of the fit, which determines colour of
the plot. Monotonicity is not checked.}

\item{...}{further arguments to be passed to \code{ggplot2::geom_raster}.}
}
\value{
An object of class gamLayer.
}
\description{
This layer adds a conditional posterior density strip to 1D smooth effects plots.
With the default colour scale, the opacity is proportional to the conditional density of the fitted
effects, under the usual Gaussian approximation the posterior.
}
\details{
See Bowman (2018) for explanations about the advantages of density strips, relative
to plots including the mean fit + confidence intervals.
}
\examples{
library(mgcViz)
set.seed(44)
dat <- gamSim(1,n=400,dist="normal",scale=2)
b <- gamV(y~s(x0)+x1+s(x2)+s(x3),data=dat)

plot(sm(b, 1)) + l_fitDens() + l_fitLine()
plot(pterm(b, 1)) + l_fitDens(trans = function(x) x^0.25) + l_fitLine()
               
}
\references{
Bowman, D. W (2018). Graphics for uncertainty. Journal of the Royal Statistical Society: Series A.
}
