% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_multi_ptermFactor.R,
%   R/plot_multi_ptermLogical.R, R/plot_ptermFactor.R, R/plot_ptermLogical.R
\name{plot.multi.ptermFactor}
\alias{plot.multi.ptermFactor}
\alias{plot.multi.ptermLogical}
\alias{plot.ptermFactor}
\alias{plot.ptermLogical}
\title{Plotting factor or logical parametric effects}
\usage{
\method{plot}{multi.ptermFactor}(x, a.facet = list(), asFact = TRUE,
  ...)

\method{plot}{multi.ptermLogical}(x, ...)

\method{plot}{ptermFactor}(x, maxpo = 10000, trans = identity, ...)

\method{plot}{ptermLogical}(x, maxpo = 10000, trans = identity, ...)
}
\arguments{
\item{x}{a factor or logical parametric effect object, extracted using \link[mgcViz:pterm]{mgcViz::pterm}.}

\item{a.facet}{arguments to be passed to \link[ggplot2:facet_wrap]{ggplot2::facet_wrap} or \link[ggplot2:facet_grid]{ggplot2::facet_grid}. The former gets
called when \code{fix} contains one vector, the latter when \code{fix} contains two vectors.}

\item{asFact}{relevant only when working with models fitted with \link{mqgamV}. If
\code{FALSE} quantile of interest (qu) is treated as a continuous variable, otherwise as
a factor.}

\item{...}{currently unused.}

\item{maxpo}{maximum number of residuals points that will be used by layers such as
\code{resRug()} and \code{resPoints()}. If number of datapoints > \code{maxpo},
then a subsample of \code{maxpo} points will be taken.}

\item{trans}{monotonic function to apply to the fit, confidence intervals and residuals,
before plotting. Monotonicity is not checked.}
}
\value{
An object of class \code{plotSmooth}.
}
\description{
These are the plotting methods for parametric factor or logical effects.
}
\examples{
# Simulate data and fit GAM
set.seed(3)
dat <- gamSim(1,n=2000,dist="normal",scale=20)
dat$fac <- as.factor( sample(c("A1", "A2", "A3"), nrow(dat), replace = TRUE) )
dat$logi <- as.logical( sample(c(TRUE, FALSE), nrow(dat), replace = TRUE) )
bs <- "cr"; k <- 12
b <- gam(y~fac + s(x0) + s(x1) + s(x2) + s(x3) + logi, data=dat)
o <- getViz(b, nsim = 0)

# Extract factor terms and plot it
pt <- pterm(o, 1)
plot(pt) + l_ciBar() + l_fitPoints(colour = 2) + l_rug(alpha = 0.2)

# Use barplot instead of points
pt <- pterm(o, 1)
plot(pt) + l_fitBar() + l_ciBar()

# Same with binary varible
pt <- pterm(o, 2)
plot(pt) + l_fitPoints() + l_ciBar()

}
