% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmev.R
\name{rmevspec}
\alias{rmevspec}
\title{Random samples from spectral distributions of multivariate extreme value models.}
\usage{
rmevspec(
  n,
  d,
  param,
  sigma,
  model = c("log", "neglog", "bilog", "negbilog", "hr", "br", "xstud", "smith",
    "schlather", "ct", "sdir", "dirmix"),
  weights,
  vario,
  coord = NULL,
  grid = FALSE,
  ...
)
}
\arguments{
\item{n}{number of observations}

\item{d}{dimension of sample}

\item{param}{parameter vector for the logistic, bilogistic, negative bilogistic and extremal Dirichlet (Coles and Tawn) model.
Parameter matrix for the Dirichlet mixture. Degree of freedoms for extremal student model. See \bold{Details}.}

\item{sigma}{covariance matrix for Brown-Resnick and extremal Student-t distributions. Symmetric matrix of squared  coefficients \eqn{\lambda^2} for the Husler-Reiss model, with zero diagonal elements.}

\item{model}{for multivariate extreme value distributions, users can choose between 1-parameter logistic and negative logistic, asymmetric logistic and negative logistic, bilogistic, Husler-Reiss, extremal Dirichlet model (Coles and Tawn) or the Dirichlet mixture. Spatial models include
the Brown-Resnick, Smith, Schlather and extremal Student max-stable processes.}

\item{weights}{vector of length \code{m} for the \code{m} mixture components. Must sum to one}

\item{vario}{semivariogram function whose first argument must be distance. Used only if provided in conjunction with \code{coord} and if \code{sigma} is missing}

\item{coord}{\code{d} by \code{k} matrix of coordinates, used as input in the variogram \code{vario} or as parameter for the Smith model. If \code{grid} is \code{TRUE}, unique entries should be supplied.}

\item{grid}{Logical. \code{TRUE} if the coordinates are two-dimensional grid points (spatial models).}

\item{...}{additional arguments for the \code{vario} function}
}
\value{
an \code{n} by \code{d} exact sample from the corresponding multivariate extreme value model
}
\description{
Generate from \eqn{Q_i}{Qi}, the spectral measure of a given multivariate extreme value model based on the L1 norm.
}
\details{
The vector param differs depending on the model
\itemize{
 \item \code{log}: one dimensional parameter greater than 1
 \item \code{neglog}: one dimensional positive parameter
 \item \code{bilog}: \code{d}-dimensional vector of parameters in \eqn{[0,1]}
 \item \code{negbilog}: \code{d}-dimensional vector of negative parameters
 \item \code{ct}, \code{dir}, \code{negdir}: \code{d}-dimensional vector of positive (a)symmetry parameters. Alternatively, a \eqn{d+1}
 vector consisting of the \code{d} Dirichlet parameters and the last entry is an index of regular variation in \eqn{(0, 1]} treated as scale
 \item \code{xstud}: one dimensional parameter corresponding to degrees of freedom \code{alpha}
 \item \code{dirmix}: \code{d} by \code{m}-dimensional matrix of positive (a)symmetry parameters
}
}
\section{Note}{

 This functionality can be useful to generate for example Pareto processes with marginal exceedances.
}

\examples{
set.seed(1)
rmevspec(n=100, d=3, param=2.5, model='log')
rmevspec(n=100, d=3, param=2.5, model='neglog')
rmevspec(n=100, d=4, param=c(0.2,0.1,0.9,0.5), model='bilog')
rmevspec(n=100, d=2, param=c(0.8,1.2), model='ct') #Dirichlet model
rmevspec(n=100, d=2, param=c(0.8,1.2,0.5), model='sdir') #with additional scale parameter
#Variogram gamma(h) = scale*||h||^alpha
#NEW: Variogram must take distance as argument
vario <- function(x, scale=0.5, alpha=0.8){ scale*x^alpha }
#grid specification
grid.coord <- as.matrix(expand.grid(runif(4), runif(4)))
rmevspec(n=100, vario=vario,coord=grid.coord, model='br')
## Example with Dirichlet mixture
alpha.mat <- cbind(c(2,1,1),c(1,2,1),c(1,1,2))
rmevspec(n=100, param=alpha.mat, weights=rep(1/3,3), model='dirmix')
}
\references{
Dombry, Engelke and Oesting (2016). Exact simulation of max-stable processes, \emph{Biometrika}, \bold{103}(2), 303--317.

Boldi (2009). A note on the representation of parametric models for multivariate extremes.
\emph{Extremes} \bold{12}, 211--218.
}
\author{
Leo Belzile
}
