% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{distg}
\alias{distg}
\title{Distance matrix with geometric anisotropy}
\usage{
distg(loc, scale, rho)
}
\arguments{
\item{loc}{a \code{d} by 2 matrix of locations giving the coordinates of a site per row.}

\item{scale}{numeric vector of length 1, greater than 1.}

\item{rho}{angle for the anisotropy, must be larger than \eqn{\pi/2} in modulus.}
}
\value{
a \code{d} by \code{d} square matrix of pairwise distance
}
\description{
The function computes the distance between locations, with geometric anisotropy.
The parametrization assumes there is a scale parameter, so that \code{scale}
is the distortion for the second component only. The angle \code{rho} must lie in
\eqn{[-\pi/2, \pi/2]}.
}
