% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recurrent.marginal.R
\name{covarianceRecurrent}
\alias{covarianceRecurrent}
\alias{plot.covariace.recurrent}
\alias{covarianceRecurrentS}
\alias{Bootcovariancerecurrence}
\alias{BootcovariancerecurrenceS}
\title{Estimation of covariance for bivariate recurrent events with terminal event}
\usage{
covarianceRecurrent(data, type1, type2, status = "status", death = "death",
  start = "start", stop = "stop", id = "id", names.count = "Count")
}
\arguments{
\item{data}{data-frame}

\item{type1}{type of first event (code) related to status}

\item{type2}{type of second event (code) related to status}

\item{status}{name of status}

\item{death}{name of death indicator}

\item{start}{start stop call of Hist() of prodlim}

\item{stop}{start stop call of Hist() of prodlim}

\item{id}{id}

\item{names.count}{name of count for number of previous event of different types, here generated by count.history()}
}
\description{
Estimation of probability of more that k events for recurrent events process
where there is terminal event
}
\examples{

########################################
## getting some data to work on 
########################################
data(base1cumhaz)
data(base4cumhaz)
data(drcumhaz)
dr <- drcumhaz
base1 <- base1cumhaz
base4 <- base4cumhaz
rr <- simRecurrent(1000,base1,cumhaz2=base4,death.cumhaz=dr)
rr <- count.history(rr)
rr$strata <- 1
dtable(rr,~death+status)

covrp <- covarianceRecurrent(rr,1,2,status="status",death="death",
                        start="entry",stop="time",id="id",names.count="Count")
par(mfrow=c(1,3)) 
plot(covrp)

### with strata, each strata in matrix column, provides basis for fast Bootstrap
covrpS <- covarianceRecurrentS(rr,1,2,status="status",death="death",
        start="entry",stop="time",strata="strata",id="id",names.count="Count")

}
\references{
Scheike, Eriksson, Tribler (2018) 
            The mean, variance and correlation for bivariate recurrent events
            with a terminal event,  work in progress
}
\author{
Thomas Scheike
}
