% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metricsgraphics.r
\name{mjs_plot}
\alias{mjs_plot}
\title{Create a new metricsgraphics.js  plot}
\usage{
mjs_plot(data, x, y, show_rollover_text = TRUE, linked = FALSE,
  decimals = 2, format = "count", missing_is_hidden = FALSE, left = 80,
  right = 10, top = 40, bottom = 60, buffer = 8, width = NULL,
  height = NULL, title = NULL, description = NULL)
}
\arguments{
\item{data}{data frame}

\item{x}{bare or quoted name of column to use for x values}

\item{y}{bare or quoted name of column to use for y values}

\item{show_rollover_text}{determines whether or not to show any text when a data point is rolled over.}

\item{linked}{inks together all other graphs whose linked option is set to true.
When one graphic in that set is rolled over, the corresponding values in the other
graphics are also rolled over (default: \code{FALSE} - not linked)}

\item{decimals}{the number of decimals to show in a rollover (default: \code{2})}

\item{format}{sets the format of the data object, which is to say,
\code{count}s or \code{percentage}s}

\item{missing_is_hidden}{if true and if the data object is a time series, missing data points will be treated as zeros}

\item{left}{the size of the left margin in pixels.}

\item{right}{the size of the right margin in pixels.}

\item{top}{the size of the top margin in pixels.}

\item{bottom}{the size of the bottom margin in pixels.}

\item{buffer}{the buffer size in pixels between the actual chart area and the margins.}

\item{width}{Width in pixels (optional, defaults to automatic sizing)}

\item{height}{Height in pixels (optional, defaults to automatic sizing)}

\item{title}{plot title}

\item{description}{plot description}
}
\value{
metricsgraphics object
}
\description{
\code{mjs_plot()} initializes the metricsgraphics.js html widget
and takes a data frame & (bare or quoted) x & y column names as minimum input.
This must be piped to a "geom" (metricsgraphics.js only supports single
"geom" layers) and can also be piped to other \code{mjs_} functions that
manipulate aesthetics.
}
\details{
See \href{http://metricsgraphicsjs.org/}{MetricsGraphics.js} for more information.
}
\note{
Plot \code{title} and \code{description} work best when the widget is in
      a Bootstrap template. They also increase the overall plot area (height,
      mostly) since they add \code{<div>}s. The \code{description} will be
      visible in the upper left area (on \code{?} hover) if not displayed
      in a Boostrap template.
}
\examples{
data.frame(year=seq(1790, 1970, 10),
           uspop=as.numeric(uspop)) \%>\%
  mjs_plot(x=year, y=uspop) \%>\%
  mjs_line()

# accessor params can also be quoted

data.frame(year=seq(1790, 1970, 10),
           uspop=as.numeric(uspop)) \%>\%
  mjs_plot(x="year", y="uspop") \%>\%
  mjs_line()

}

