% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelStMoE.R
\docType{class}
\name{ModelStMoE-class}
\alias{ModelStMoE-class}
\alias{ModelStMoE}
\title{A Reference Class which represents a fitted StMoE model.}
\description{
ModelStMoE represents an estimated StMoE model.
}
\section{Fields}{

\describe{
\item{\code{param}}{A \link{ParamStMoE} object. It contains the estimated
values of the parameters.}

\item{\code{stat}}{A \link{StatStMoE} object. It contains all the statistics
associated to the StMoE model.}
}}

\section{Methods}{

\describe{
\item{\code{plot(what = c("meancurve", "confregions", "clusters", "loglikelihood"), ...)}}{Plot method.
\describe{
  \item{\code{what}}{The type of graph requested:
    \itemize{
      \item \code{"meancurve" = } Estimated mean and estimated
        experts means given the input \code{X} (fields \code{Ey} and
        \code{Ey_k} of class \link{StatStMoE}).
      \item \code{"confregions" = } Estimated mean and confidence
        regions. Confidence regions are computed as plus and minus twice
        the estimated standard deviation (the squarre root of the field
        \code{Vary} of class \link{StatStMoE}).
      \item \code{"clusters" = } Estimated experts means (field
        \code{Ey_k}) and hard partition (field \code{klas} of class
        \link{StatStMoE}).
      \item \code{"loglikelihood" = } Value of the log-likelihood for
        each iteration (field \code{stored_loglik} of class
        \link{StatStMoE}).
    }
  }
  \item{\code{\dots}}{Other graphics parameters.}
}
By default, all the graphs mentioned above are produced.}

\item{\code{summary(digits = getOption("digits"))}}{Summary method.
\describe{
  \item{\code{digits}}{The number of significant digits to use when
    printing.}
}}
}}

\examples{
data(tempanomalies)
x <- tempanomalies$Year
y <- tempanomalies$AnnualAnomaly

stmoe <- emStMoE(X = x, Y = y, K = 2, p = 1, threshold = 1e-4, verbose = TRUE)

# stmoe is a ModelSTMoE object. It contains some methods such as 'summary' and 'plot'
stmoe$summary()
stmoe$plot()

# stmoe has also two fields, stat and param which are reference classes as well

# Log-likelihood:
stmoe$stat$loglik

# Parameters of the polynomial regressions:
stmoe$param$beta
}
\seealso{
\link{ParamStMoE}, \link{StatStMoE}
}
