% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/print.meteDist.R
\name{print.meteDist}
\alias{print.meteDist}
\title{Print summaries of \code{meteDist} objects}
\usage{
\method{print}{meteDist}(x, ...)
}
\arguments{
\item{x}{a \code{meteDist} object (e.g. from \code{ipd.mete} or \code{sad.mete})}

\item{...}{arguments to be passed}
}
\value{
The \code{meteDist} object is returned invisibly
}
\description{
S3 method for class \code{meteDist}
}
\details{
Prints state variables and lagrange multipliers
}
\examples{
data(arth)
esf1 <- meteESF(spp=arth$spp,
                abund=arth$count,
                power=arth$mass^(.75),
                minE=min(arth$mass^(.75)))
ipd1 <- ipd(esf1)
ipd1
}
\author{
Andy Rominger <ajrominger@gmail.com>, Cory Merow
}
\references{
Harte, J. 2011. Maximum entropy and ecology: a theory of abundance, distribution, and energetics. Oxford University Press.
}

